% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_apa.R
\name{t_apa}
\alias{t_apa}
\title{Report t-Test in APA style}
\usage{
t_apa(
  x,
  es = "cohens_d",
  es_ci = FALSE,
  format = c("text", "markdown", "rmarkdown", "html", "latex", "latex_math", "docx",
    "plotmath"),
  info = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{A call to \code{t_test} or \code{t.test}}

\item{es}{Character specifying the effect size to report. One of
\code{"cohens_d"} (default), \code{"hedges_g"} or \code{"glass_delta"} if
\code{x} is an independent samples t-test. Ignored if \code{x} is a paired
samples or one sample t-test (cohen's d is reported for these test).}

\item{es_ci}{Logical indicating whether to add the 95% confidence interval
for Cohen's d (experimental; default is \code{FALSE}).}

\item{format}{Character string specifying the output format. One of
\code{"text"}, \code{"markdown"}, \code{"rmarkdown"}, \code{html},
\code{"latex"}, \code{"latex_math"}, \code{"docx"} or \code{"plotmath"}.}

\item{info}{Logical indicating whether to print a message on the used test
(default is \code{FALSE})}

\item{print}{Logical indicating whether to print the formatted output via
\code{cat} (\code{TRUE}, default) or return as character string.}
}
\description{
Report t-Test in APA style
}
\examples{
# Two independent samples t-test
t_apa(t_test(1:10, y = c(7:20)))

# Two dependent samples t-test
t_apa(t_test(extra ~ group, sleep, paired = TRUE))

}
