% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apaANOVATable2way.R
\name{apa.2way.table}
\alias{apa.2way.table}
\title{Creates a table of means and standard deviations for a 2-way ANOVA design in APA style}
\usage{
apa.2way.table(iv1, iv2, dv, data, filename = NA, table.number = NA,
  show.conf.interval = FALSE, show.marginal.means = FALSE,
  landscape = FALSE)
}
\arguments{
\item{iv1}{Name of independent variable 1 column in data frame}

\item{iv2}{Name of independent variable 2 column in data frame}

\item{dv}{Name of dependent variable column in data frame}

\item{data}{Project data frame name}

\item{filename}{(optional) Output filename document filename (must end in .rtf or .doc only)}

\item{table.number}{Integer to use in table number output line}

\item{show.conf.interval}{(TRUE/FALSE) Display confidence intervals in table. Negates show.marginal.means = TRUE.}

\item{show.marginal.means}{(TRUE/FALSE) Show marginal means in output. Only used if show.conf.interval = FALSE.}

\item{landscape}{(TRUE/FALSE) Make RTF file landscape}
}
\value{
APA table object
}
\description{
Creates a table of means and standard deviations for a 2-way ANOVA design in APA style
}
\examples{
# Example 2: 2-way from Fidler & Thompson (2001)
apa.2way.table(iv1=a,iv2=b,dv=dv,data=fidler_thompson,landscape=TRUE, filename="ex2_desc_table.doc")

# Example 3: 2-way from Field et al. (2012) Discovery Statistics Using R
apa.2way.table(iv1=gender,iv2=alcohol,dv=attractiveness,data=goggles,filename="ex3_desc_table.doc")
}

