% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facets.R
\name{apex-facets}
\alias{apex-facets}
\alias{ax_facet_wrap}
\alias{ax_facet_grid}
\title{Facets for ApexCharts}
\usage{
ax_facet_wrap(
  ax,
  facets,
  nrow = NULL,
  ncol = NULL,
  scales = c("fixed", "free", "free_y", "free_x"),
  labeller = label_value,
  chart_height = "300px"
)

ax_facet_grid(
  ax,
  rows = NULL,
  cols = NULL,
  scales = c("fixed", "free", "free_y", "free_x"),
  labeller = label_value,
  chart_height = "300px"
)
}
\arguments{
\item{ax}{An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.}

\item{facets}{Variable(s) to use for facetting, wrapped in \code{vars(...)}.}

\item{nrow, ncol}{Number of row and column in output matrix.}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"}, \code{"free_y"})?}

\item{labeller}{A function with one argument containing for each facet the value of the faceting variable.}

\item{chart_height}{Individual chart height.}

\item{rows, cols}{A set of variables or expressions quoted by \code{vars()}
and defining faceting groups on the rows or columns dimension.}
}
\value{
An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object with an additionnal class \code{"apex_facet"}.
}
\description{
Create matrix of charts by row and column faceting variable (\code{ax_facet_grid}),
or by specified number of row and column for faceting variable(s) (\code{ax_facet_wrap}).
}
\section{Warning}{
To properly render in Shiny applications, use \code{\link[=apexfacetOutput]{apexfacetOutput()}} (in UI) and \code{\link[=renderApexfacet]{renderApexfacet()}} (in Server).
}

\examples{
### Wrap --------

if (interactive()) {
  library(apexcharter)
  
  # Scatter ----
  
  data("mpg", package = "ggplot2")
  
  # Create facets
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_facet_wrap(vars(drv))
  
  # Change number of columns
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_facet_wrap(vars(drv), ncol = 2)
  
  # Free axis
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_facet_wrap(vars(drv), ncol = 2, scales = "free")
  
  # labels
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_facet_wrap(
      vars(drv), ncol = 2,
      labeller = function(x) {
        switch(
          x,
          "f" = "front-wheel drive", 
          "r" = "rear wheel drive",
          "4" = "4wd"
        )
      }
    )
  
  # Title and subtitle are treated as global
  apex(mpg, aes(displ, cty), type = "scatter") \%>\%
    ax_labs(
      title = "Facet wrap example",
      subtitle = "mpg data from ggplot2"
    ) \%>\% 
    ax_facet_wrap(vars(drv), ncol = 2)
  
  
  # Multiple variables
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_facet_wrap(vars(year, drv))
  
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_facet_wrap(vars(year, drv), ncol = 2, nrow = 3)
  
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_chart(toolbar = list(show = FALSE)) \%>\% 
    ax_facet_wrap(
      vars(year, drv),
      labeller = function(x) {
        paste(x, collapse = " / ")
      }
    )
  
  
  
  # Lines ----
  
  data("unhcr_ts")
  refugees <- unhcr_ts \%>\% 
    subset(population_type == "Refugees (incl. refugee-like situations)") \%>\% 
    transform(date = as.Date(paste0(year, "-01-01")))
  
  
  apex(refugees, aes(date, n), type = "line") \%>\% 
    ax_yaxis(tickAmount = 5) \%>\% 
    ax_facet_wrap(vars(continent_origin))
  
  
  
  # Free y-axis and synchronize
  apex(refugees, aes(date, n), type = "line", synchronize = "my-id") \%>\% 
    ax_yaxis(tickAmount = 5) \%>\% 
    ax_xaxis(tooltip = list(enabled = FALSE)) \%>\% 
    ax_tooltip(x = list(format = "yyyy")) \%>\% 
    ax_facet_wrap(vars(continent_origin), scales = "free_y")
  
  
  
  # Bars ----
  
  data("unhcr_ts")
  refugees <- unhcr_ts \%>\% 
    subset(year == 2017)
  
  apex(refugees, aes(continent_origin, n), type = "column") \%>\% 
    ax_yaxis(
      labels = list(
        formatter = format_num("~s")
      ),
      tickAmount = 5
    ) \%>\% 
    ax_facet_wrap(vars(population_type), ncol = 2)
  
}

### Grid --------
if (interactive()) {
  library(apexcharter)
  
  # Scatter ----
  
  data("mpg", package = "ggplot2")
  
  # Only rows
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_facet_grid(rows = vars(drv), chart_height = "200px")
  
  # Only cols
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_facet_grid(cols = vars(year))
  
  # Rows and Cols
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_facet_grid(rows = vars(drv), cols = vars(year))
  
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_chart(toolbar = list(show = FALSE)) \%>\% 
    ax_facet_grid(vars(drv), vars(cyl))
  
  
  # Labels
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_facet_grid(
      vars(drv),
      labeller = function(x) {
        switch(
          x,
          "f" = "front-wheel drive", 
          "r" = "rear wheel drive",
          "4" = "4wd"
        )
      }
    )
  
  
  # Title and subtitle are treated as global
  apex(mpg, aes(displ, cty), type = "scatter") \%>\% 
    ax_labs(
      title = "Facet grid example",
      subtitle = "mpg data from ggplot2"
    ) \%>\% 
    ax_facet_grid(rows = vars(drv), cols = vars(year))
  
}
}
