% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_chart}
\alias{ax_chart}
\title{Chart parameters}
\usage{
ax_chart(
  ax,
  type = NULL,
  stacked = NULL,
  stackType = NULL,
  defaultLocale = NULL,
  locales = NULL,
  animations = NULL,
  background = NULL,
  foreColor = NULL,
  dropShadow = NULL,
  events = NULL,
  offsetX = NULL,
  offsetY = NULL,
  selection = NULL,
  sparkline = NULL,
  toolbar = NULL,
  zoom = NULL,
  width = NULL,
  height = NULL,
  ...
)
}
\arguments{
\item{ax}{An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.}

\item{type}{Specify the chart type. Available Options: \code{"bar"}, \code{"column"}, \code{"line"},
\code{"pie"}, \code{"donut"}, \code{"radialBar"}, \code{"scatter"}, \code{"bubble"}, \code{"heatmap"}.}

\item{stacked}{Logical. Enables stacked option for axis charts.}

\item{stackType}{When stacked, should the stacking be percentage based or normal stacking.
Available options: \code{"normal"} or \code{"100\%"}.}

\item{defaultLocale}{Locale to use : \code{"ca"}, \code{"cs"}, \code{"de"},
\code{"el"}, \code{"en"}, \code{"es"}, \code{"fi"}, \code{"fr"}, \code{"he"},
\code{"hi"}, \code{"hr"}, \code{"hy"}, \code{"id"}, \code{"it"}, \code{"ko"},
\code{"lt"}, \code{"nb"}, \code{"nl"}, \code{"pl"}, \code{"pt-br"}, \code{"pt"},
\code{"ru"}, \code{"se"}, \code{"sk"}, \code{"sl"}, \code{"th"}, \code{"tr"},
\code{"ua"}.}

\item{locales}{Array of custom locales parameters.}

\item{animations}{A list of parameters.}

\item{background}{Background color for the chart area. If you want to set background with css, use \code{.apexcharts-canvas} to set it.}

\item{foreColor}{Sets the text color for the chart. Defaults to \code{#373d3f}.}

\item{dropShadow}{A list of parameters. See \url{https://apexcharts.com/docs/options/chart/dropshadow/}.}

\item{events}{See \code{\link{events_opts}}.}

\item{offsetX}{Sets the left offset for chart.}

\item{offsetY}{Sets the top offset for chart.}

\item{selection}{A list of parameters.}

\item{sparkline}{List. Sparkline hides all the elements of the charts other than the primary paths. Helps to visualize data in small areas. .}

\item{toolbar}{A list of parameters. See \url{https://apexcharts.com/docs/options/chart/toolbar/}.}

\item{zoom}{A list of parameters. See \url{https://apexcharts.com/docs/options/chart/zoom/}.}

\item{width}{Width of the chart.}

\item{height}{Height of the chart.}

\item{...}{Additional parameters.}
}
\value{
An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.
}
\description{
Chart parameters
}
\examples{
library(apexcharter)
data("diamonds", package = "ggplot2")

##  Stack bar type
# default is dodge
apex(
  data = diamonds,
  mapping = aes(x = cut, fill = color)
)

# stack
apex(
  data = diamonds,
  mapping = aes(x = cut, fill = color)
) \%>\%
  ax_chart(stacked = TRUE)

# stack filled
apex(
  data = diamonds,
  mapping = aes(x = cut, fill = color)
) \%>\%
  ax_chart(stacked = TRUE, stackType = "100\%")




# Toolbar --------------------------------------

# Hide the toolbar
apex(
  data = diamonds,
  mapping = aes(x = cut, fill = color)
) \%>\%
  ax_chart(toolbar = list(show = FALSE))

# Hide download buttons
data("economics", package = "ggplot2")
apex(
  data = economics,
  mapping = aes(x = date, y = pce), 
  type = "line"
) \%>\%
  ax_chart(
    toolbar = list(tools= list(download = FALSE))
  )



# Zoom -----------------------------------------

# Disable
apex(
  data = economics,
  mapping = aes(x = date, y = pce), 
  type = "line"
) \%>\%
  ax_chart(
    zoom = list(enabled = FALSE)
  )


# Auto-scale Y axis
apex(
  data = economics,
  mapping = aes(x = date, y = pce), 
  type = "line"
) \%>\%
  ax_chart(
    zoom = list(autoScaleYaxis = TRUE)
  )

# Localization ---------------------------------


# Use included localization config
dat <- data.frame(
  x = Sys.Date() + 1:20,
  y = sample.int(20, 20)
)

# French
apex(dat, aes(x, y), "line") \%>\% 
  ax_chart(defaultLocale = "fr")

# Italian
apex(dat, aes(x, y), "line") \%>\% 
  ax_chart(defaultLocale = "it")



# Custom config
apex(dat, aes(x, y), "line") \%>\% 
  ax_chart(locales = list(
    list(
      name = "en", # override 'en' locale
      options = list(
        toolbar = list(
          exportToSVG = "GET SVG",
          exportToPNG = "GET PNG"
        )
      )
    )
  ))

}
