% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_labels}
\alias{ax_labels}
\alias{ax_labels2}
\title{Alternative axis labels}
\usage{
ax_labels(ax, ...)

ax_labels2(ax, labels)
}
\arguments{
\item{ax}{An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.}

\item{...}{Vector. In Axis Charts (line / column), labels can be set instead of setting xaxis categories
option. While, in pie/donut charts, each label corresponds to value in series array.}

\item{labels}{A vector to use as labels.}
}
\value{
An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.
}
\description{
Alternative axis labels
}
\note{
See \url{https://apexcharts.com/docs/options/labels/}
}
\examples{
apexchart() \%>\% 
  ax_chart(type = "pie") \%>\% 
  ax_series(23, 45, 56) \%>\% 
  ax_labels("A", "B", "C")

# same as 
apexchart() \%>\% 
  ax_chart(type = "pie") \%>\% 
  ax_series2(c(23, 45, 56)) \%>\% 
  ax_labels2(c("A", "B", "C"))
}
