% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashape.R
\name{datashape}
\alias{datashape}
\title{Data shaping tools}
\usage{
datashape(dataset, y, x, subs)
}
\arguments{
\item{dataset}{a dataframe or matrix containing user data.}

\item{y}{the column number of the outcome variable in dataset d.}

\item{x}{a vector containing the explanatory or predictor variables of interest.
The new data matrix will only contain these variables and the outcome
variable.}

\item{subs}{a vector describing a subset of rows from dataset d to include in the
returned data matrix.}
}
\value{
This function returns a matrix conforming to the specifications supplied to
the datashape function.
}
\description{
Generate a new dataset in a format that is accepted by \code{\link{compare}}. Dummy variables are
created for categorical variables.
}
\details{
This function can be used to prepare a dataset before applying the
\code{\link{compare}} function. The outcome column number must be
specified, and specific predictors and observation subsets may be specified. 2-level
categorical variables will be converted to binary, while dummy variables will be
created for categorical predictors with greater than two levels.

The "datashaped" dataset should be saved to a new object.
}
\section{Warning}{

 \code{datashape} will not function if missing values are present.

 @examples
## Preparing the iris dataset
   data(iris)
   iris.shaped <- datashape(dataset = iris, y = 4)
   head(iris.shaped)
## Creating a copy of iris with sepal-related predictors and a subset of observations.
   iris.sub <- datashape(dataset = iris, y = 4, x = c(1,2), subs = c(1:20, 50:70))
   head(iris.sub)
}

