% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sensitivityAPSIM.R
\name{apsim_vector}
\alias{apsim_vector}
\title{Edit and Run an APSIM Simulation}
\usage{
apsim_vector(X, exe, wd, vars, to.run, to.edit = to.run, overwrite = FALSE,
  g)
}
\arguments{
\item{X}{N-by-p matrix of inputs with rows corresponding to runs and columns for variables}

\item{exe}{where to find the APSIM executable}

\item{wd}{directory where the .apsim file lives and where the results will be saved}

\item{vars}{names of the variables, must be of the same length as 'X' has columns}

\item{to.run}{the .apsim file in \code{wd} to run}

\item{to.edit}{the .apsim file or .xml file to be edited}

\item{overwrite}{logical; passed to the \code{edit_apsim} and \code{edit_sim_file} functions}

\item{g}{a function of the output returned by apsim - must give vector or scalar result}
}
\value{
a vector of length N
}
\description{
This function will edit then run an APSIM simulation.  It can be thought of as a vectorized
version of \code{\link[apsimr:apsim]{apsim}}.
}
\details{
In order to link between the \code{\link[sensitivity]{sensitivity}} package and
APSIM, there needs to be a function that can edit then run APSIM that produces
a univariate output.  The \code{apsim_vector} function satisfies these conditions
and can return multivariate output if a multivariate sensitivity analysis is of interest.
See the examples section or the package vignette for details.
}
\examples{
\dontrun{
meanCowpea<-function(X){
 return(mean(X$lai_cowpea))
}

apsimWd <- "~/APSIM"
apsimVar <- c(rep("SoilWater/Thickness",11), "SoilOrganicMatter/SoilCN")
apsimValue <- matrix(c(rep(200, 2), rep(300, 9), 10,
                       rep(350, 2), rep(350, 9), 5),nrow=2,byrow=T)
apsimExe <-"C:/Program Files (x86)/Apsim75-r3008/Model/Apsim.exe"
apsimFile <- "Canopy.apsim"

#Run APSIM at each new parameter vector specified by apsimVar and only return the mean cowpea value
uniRes <- apsim_vector(X = apsimValue, exe = apsimExe, wd = apsimWd, vars = apsimVar,
         to.run = apsimFile, to.edit = apsimFile, g = meanCowpea)
uniRes


allCowpea <- function(x){
 return(x$lai_cowpea)
}

#Use allCowpea function to return all the cowpea values
multiRes <- apsim_vector(X = apsimValue, exe = apsimExe, wd = apsimWd, vars = apsimVar,
             to.run = apsimFile, to.edit = apsimFile, g = allCowpea)
multiRes
}
}

