% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_apsimx.R
\name{view_apsimx}
\alias{view_apsimx}
\title{Viewing an APSIM-X file interactively}
\usage{
view_apsimx(file, src.dir, viewer = c("json", "react"), ...)
}
\arguments{
\item{file}{a file ending in .apsimx to be inspected (JSON)}

\item{src.dir}{directory containing the .apsimx file to be inspected; defaults to the current working directory}

\item{viewer}{either \dQuote{json} or \dQuote{react}.}

\item{...}{additional arguments passed to either \sQuote{jsonedit} or \sQuote{reactjson}.
These are functions in package \CRANpkg{listviewer}.}
}
\description{
Generate an interactive viewer for an APSIM-X file
}
\note{
I do not know how to edit an APSIM-X file using this method yet.
}
\examples{
\dontrun{
extd.dir <- system.file("extdata", package = "apsimx")
## View the structure of the APSIM-X simulation file
view_apsimx("Wheat.apsimx", src.dir = extd.dir)
}

}
