% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsim_classic.R
\name{read_apsim}
\alias{read_apsim}
\title{Read APSIM generated .out files}
\usage{
read_apsim(
  file = "",
  src.dir = ".",
  value = c("report", "all"),
  date.format = "\%d/\%m/\%Y"
)
}
\arguments{
\item{file}{file name}

\item{src.dir}{source directory where file is located}

\item{value}{either \sQuote{report} (data.frame) or \sQuote{all} (list)}

\item{date.format}{format for adding \sQuote{Date} column}
}
\description{
read \sQuote{output} databases created by APSIM runs (.out and .sim). One file at a time.
}
\details{
Read APSIM generated .out files
}
\examples{
\dontrun{
extd.dir <- system.file("extdata", package = "apsimx")
maize.out <- read_apsim("Maize", src.dir = extd.dir, value = "report")
millet.out <- read_apsim("Millet", src.dir = extd.dir, value = "report")
}

}
