% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBracket.R
\name{addBracket}
\alias{addBracket}
\title{Add Depth Brackets}
\usage{
addBracket(
  x,
  label.cex = 0.75,
  tick.length = 0.05,
  arrow.length = 0.05,
  offset = -0.3,
  missing.bottom.depth = NULL,
  ...
)
}
\arguments{
\item{x}{\code{data.frame} object containing \code{idname(x)}, \code{top}, \code{bottom}, and optionally \code{label} columns}

\item{label.cex}{scaling factor for label font}

\item{tick.length}{length of bracket "tick" mark}

\item{arrow.length}{length of arrowhead}

\item{offset}{left-hand offset from each profile}

\item{missing.bottom.depth}{distance (in depth units) to extend brackets that are missing a lower depth (defaults to max depth of collection)}

\item{...}{further arguments passed on to \code{segments} or \code{arrows}}
}
\description{
Add depth brackets to soil profile sketches.
}
\details{
\code{x} may contain multiple records per profile. Additional examples can be found in \href{http://ncss-tech.github.io/AQP/aqp/SPC-plotting-ideas.html}{this tutorial}.
}
\note{
This is a \code{low-level} plotting function: you must first plot a \code{SoilProfileCollection} object before using this function.
}
\examples{

# sample data
data(sp1)

# add color vector
sp1$soil_color <- with(sp1, munsell2rgb(hue, value, chroma))

# promote to SoilProfileCollection
depths(sp1) <- id ~ top + bottom

# plot profiles
par(mar = c(0, 0, 0, 1))
plotSPC(sp1, width = 0.3)

# extract min--max depths associated with all A horizons
# result is a single-row data.frame / profile
combinedBracket <- function(i) {
  h <- horizons(i)
  idn <- idname(i)
  this.id <- h[[idn]][1]
  
  idx <- grep('^A', h$name)
  
  res <- data.frame(
    id = this.id,
    top = min(h$top[idx]), 
    bottom = max(h$bottom[idx], na.rm=TRUE)
  )
  names(res)[1] <- idn
  
  return(res)
}

# return matching horizon top / bottom depths for A or C horizons
# result is a 0 or more row data.frame / profile
individualBrackets <- function(i) {
  h <- horizons(i)
  idn <- idname(i)
  this.id <- h[[idn]][1]
  
  idx <- grep('^A|^C', h$name)
  
  res <- data.frame(
    id = this.id,
    top = h$top[idx], 
    bottom = h$bottom[idx]
  )
  names(res)[1] <- idn
  
  return(res)
}

# combined brackets
b1 <- profileApply(sp1, combinedBracket, frameify = TRUE)

# individual brackets
b2 <- profileApply(sp1, individualBrackets, frameify = TRUE)

# plot in reverse order
plotSPC(sp1, plot.order = rev(1:length(sp1)))

# note that plotting order is derived from the call to `plotSPC(sp1)`
addBracket(b1, col='red')

# plot in reverse order
plotSPC(sp1, plot.order = rev(1:length(sp1)))

# note that plotting order is derived from the call to `plotSPC(sp1)`
addBracket(b2, col='red')


}
\seealso{
\code{\link{addDiagnosticBracket}, \link{plotSPC}}
}
\author{
D.E. Beaudette
}
