% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarMunsellChips.R
\name{.makeEquivalentMunsellLUT}
\alias{.makeEquivalentMunsellLUT}
\title{.makeEquivalentMunsellLUT}
\usage{
.makeEquivalentMunsellLUT(threshold = 0.001)
}
\arguments{
\item{threshold}{Quantile cutoff (of dE00 color contrast) for "equivalent" colors, default \code{0.001} based on all whole value/chroma "chips" in the \code{munsell} data set.}
}
\value{
A list with equal length to the number of rows (chips) in \code{munsell} data, each containing a numeric vector of row indices that are equivalent (CIE2000 distance less than \code{threshold}).
}
\description{
Makes the look up table based on pair-wise CIE2000 color contrast (\code{dE00}) of LAB colors with D65 illuminant of LAB colors for all whole value/chroma "chips" in the \code{aqp::munsell} data set via \code{farver::compare_colour}. Specify a threshold in terms of a probability level of CIE2000 distance (relative to whole dataset).
}
\examples{
\dontrun{

  # use default threshold
  equivalent_chip_lut <- .makeEquivalentMunsellLUT()

  # inspect the first 10 chips, it seems to work!
  lapply(equivalent_chip_lut[1:10], function(i) munsell[i,])

  # lets see some info on the number of chips per chip
  nchipsper <- sapply(equivalent_chip_lut, length)

  # top 10 are very high chroma chips with over 70 chips "identical"
  nchipsper[order(nchipsper, decreasing = TRUE)[1:10]]

  # look at distribution
  plot(density(nchipsper))

  # median is 5 -- Q: is this true of the range of Munsell colors typically used for soils?
  quantile(nchipsper)

  # double the default threshold
  doubletest <- sapply(.makeEquivalentMunsellLUT(threshold = 0.002), length)
  lines(density(doubletest), lty=2)

  # apprx. doubles the number of chips per chip in IQR
  quantile(doubletest)
}

}
\references{
Gaurav Sharma, Wencheng Wu, Edul N. Dalal. (2005). The CIEDE2000 Color-Difference Formula: Implementation Notes, Supplementary Test Data, and Mathematical Observations. COLOR research and application. 30(1):21-30. http://www2.ece.rochester.edu/~gsharma/ciede2000/ciede2000noteCRNA.pdf

Thomas Lin Pedersen, Berendea Nicolae and Romain François (2020). farver: High Performance Colour Space Manipulation. R package version 2.0.3. https://CRAN.R-project.org/package=farver

Dong, C.E., Webb, J.B., Bottrell, M.C., Saginor, I., Lee, B.D. and Stern, L.A. (2020). Strengths, Limitations, and Recommendations for Instrumental Color Measurement in Forensic Soil Characterization. J Forensic Sci, 65: 438-449. https://doi.org/10.1111/1556-4029.14193
}
\seealso{
\code{\link{equivalentMunsellChips}}
}
