% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SoilProfileCollection.R,
%   R/SoilProfileCollection-setters.R
\docType{methods}
\name{site}
\alias{site}
\alias{site,SoilProfileCollection-method}
\alias{site<-}
\alias{site<-,SoilProfileCollection-method}
\title{Retrieve site data from SoilProfileCollection}
\usage{
\S4method{site}{SoilProfileCollection}(object)

site(object) <- value
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{value}{A formula or object inheriting \code{data.frame}}
}
\description{
Get site data from SoilProfileCollection. Result is returned in the same \code{data.frame} class used to initially construct the SoilProfileCollection.

There are two options available via the \code{site<-} setter.

The first is a "normalization" by formula interface, whereby one specifies an attribute that is constant in horizons within profiles to be promoted to a site-level variable: \code{site(spc) <- ~ horizonvariable}

The second is creation of site data from an external \code{data.frame} via merge (LEFT JOIN). There must be one or more same-named columns (with at least some matching data) on the left and right hand side to facilitate the join: \code{site(spc) <- newdata}
}
\examples{

# load test data
data(sp2)

# promote to SPC
depths(sp2) <- id ~ top + bottom

# normalize a horizon-level attribute to site
site(sp2) <- ~ surface

# inspect site table
site(sp2)

# make some data: classify two geomorphic surfaces with numeric value
newdata <- data.frame(surface = c("holocene",
                                  "lower riverbank"),
                      newvalue = c(1,2))

# do left join based on newly-normalized "surface" attribute
site(sp2) <- newdata

# inspect site table: holocene & lower riverbank have values
site(sp2)

}
