% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-methods.R,
%   R/SoilProfileCollection-setters.R
\name{depths}
\alias{depths}
\alias{depths,SoilProfileCollection-method}
\alias{depths<-,SoilProfileCollection-method}
\alias{depths<-}
\alias{depths<-,data.frame-method}
\title{Initialize a SoilProfileCollection from data.frame}
\usage{
\S4method{depths}{SoilProfileCollection}(x, hzID = FALSE, ...)

\S4method{depths}{SoilProfileCollection}(object) <- value

\S4method{depths}{data.frame}(object) <- value
}
\arguments{
\item{x}{A SoilProfileCollection}

\item{hzID}{Include horizon ID? Usually this is calculated from the (sorted) row index unless \verb{hzidname()<-} has been called. Default: \code{FALSE}}

\item{...}{not used}

\item{object}{An object to promote to SoilProfileCollection (inherits from data.frame)}

\item{value}{A formula specifying the unique profile ID, top and bottom depth column names}
}
\value{
a \code{data.frame} containing profile ID, top depth, and bottom depth
}
\description{
\verb{depths(<data.frame>) <- <formula>}: Initialize SoilProfileCollection

\verb{depths(<SoilProfileCollection>)}: Extract profile ID and horizon depths from SoilProfileCollection
}
\details{
The input horizon data, and the resulting profile order, is sorted based on unique profile ID and top depth. ID columns are converted to character, depth columns are converted to integer. If \code{NA} values exist in all of the top depths, a prototype with 1 horizon per profile ID is returned, with \code{NA} in all non-essential columns. If the input \code{object} has 0 rows, a prototype with 0 horizons and 0 rows, but same column names as \code{object}, is returned.
}
\examples{
# load a SoilProfileCollection
data(jacobs2000, package = "aqp")

depths(jacobs2000)
## init SoilProfileCollection objects from data.frame of horizon data

# load demo data
data(sp1)

# promote to SPC
depths(sp1) <- id ~ top + bottom

# plot
plot(sp1)

# number of profiles
length(sp1)

# number of horizons
nrow(sp1)

}
\seealso{
\code{horizons()} \code{idname()} \code{hzidname()} \code{horizonDepths()}
}
