% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillHzGaps.R
\name{fillHzGaps}
\alias{fillHzGaps}
\title{Find and Fill Horizon Gaps}
\usage{
fillHzGaps(x, flag = TRUE, to_top = 0, to_bottom = max(x))
}
\arguments{
\item{x}{\code{SoilProfileCollection} object}

\item{flag}{logical, flag empty horizons that have been added. default: \code{TRUE}}

\item{to_top}{numeric, fill from shallowest top depth in each profile to specified depth? default: \code{0}}

\item{to_bottom}{numeric, fill from deepest bottom depth in each profile to specified depth? default: \code{aqp::max(x)}}
}
\value{
a possibly modified \code{SoilProfileCollection} object
}
\description{
This function attempts to find "gaps" in the horizon records of a \code{SoilProfileCollection} object and fill with placeholder horizons (profile ID, horizon ID, to/bottom depths, all else \code{NA}). Missing horizon records between the top of each profile and \code{to_top}, or the bottom of each profile and \code{to_bottom} are treated as gaps when those arguments are not \code{NULL}. You can use this function to prepare a potentially messy \code{SoilProfileCollection} for subsequent analyses that are sensitive to horizon sequence inconsistencies or require a conformal "rectangle" of data spanning known depths.

Gaps are defined as:
\itemize{
\item within each profile, for horizons \code{i} to \code{n_hz}:
\item \verb{bottom_i != top_i+1 (but only to i = 1:(n_hz - 1)}
}
}
\examples{

data(sp4)
depths(sp4) <- id ~ top + bottom

# introduce depth logic errors
idx <- c(2, 6:7, 8, 12)
sp4$top[idx] <- NA

# check
horizons(sp4)[idx, ]

# create gaps by removing logic errors
x <- HzDepthLogicSubset(sp4, byhz = TRUE)

# check on removed horizons (hzID values)
metadata(x)$removed.horizons

# inspect
par(mar = c(0, 0, 0, 2))
plotSPC(x, width = 0.3, default.color = 'royalblue', 
name = 'hzID', name.style = 'center-center', cex.names = 0.8,
cex.id = 0.66)

# fill gaps left by HzDepthLogicSubset()
z <- fillHzGaps(x, flag = TRUE)

# graphical check
plotSPC(z, width = 0.3, color = '.filledGap', name = 'hzID', 
show.legend = FALSE, name.style = 'center-center', cex.names = 0.8,
cex.id = 0.66)

# fill top to 0 cm
z2 <- fillHzGaps(x, flag = TRUE, to_top = 0)
plotSPC(z2, width = 0.3, color = '.filledGap', name = 'hzID', show.legend = FALSE)

# fill bottom to max(SPC)
z3 <- fillHzGaps(x, flag = TRUE, to_top = 0, to_bottom = max(x))
plotSPC(z3, width = 0.3, color = '.filledGap', name = 'hzID', show.legend = FALSE)

## another example
data(sp4)
depths(sp4) <- id ~ top + bottom

# remove 1st horizons from profiles 1:4
idx <- sp4[,, .FIRST, .HZID]
replaceHorizons(sp4) <- horizons(sp4)[-idx[1:4], ]

# prepare for dice()
z <- fillHzGaps(sp4, to_top = 0, to_bottom = 50, flag = TRUE) 

# empty-horizon padding is in place for formula interface to dice()
d <- dice(z, fm = 0:50 ~ .)
plotSPC(d, color = 'Ca', show.legend = FALSE)
plotSPC(d, color = '.filledGap', show.legend = FALSE)

}
\author{
A.G. Brown and D.E. Beaudette
}
