% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentSieve.R
\name{fragmentSieve}
\alias{fragmentSieve}
\title{Sieve the Coarse Fraction of Soil}
\usage{
fragmentSieve(
  diameter,
  sieves = NULL,
  ordered = FALSE,
  prefix = "",
  new_names = NULL,
  ...
)
}
\arguments{
\item{diameter}{numeric. Vector of diameters of coarse fragments to "sieve". Default \code{sieves} are specified in millimeters.}

\item{sieves}{leave as \code{NULL} to use fragment class labels and diameters defined by \code{\link[=fragmentClasses]{fragmentClasses()}}, or a named vector of fragment diameters. See examples.}

\item{ordered}{logical. Return as an ordered factor.}

\item{prefix}{character. Add a prefix to result names? Default: \code{""} adds no prefix. For example \code{"para"} might be used for size classes of pararock fragments.}

\item{new_names}{Optional: apply new labels to result classes. Should match length of \code{sieves}.}

\item{...}{additional arguments to \code{\link[=fragmentClasses]{fragmentClasses()}}, such as \code{sys}, \code{flat}, and \code{rounded}, see examples.}
}
\value{
character. Size class labels based on names of \code{sieves}, \code{new_names}, and \code{prefix} (if specified).
}
\description{
Sieve applies thresholds to a numeric vector of fragment diameter values, returning fragment size classes. Particle diameter thresholds are evaluated as \code{d < threshold}.
}
\examples{

# use a simplified version of the USDA system
# common within NRCS/SPSD and NCSS
fragmentSieve(c(30, 125, 180, 500, 1000))

# pararock fragments
fragmentSieve(c(30, 125, 180, 500, 1000), prefix = 'para')

# result as an ordered factor
fragmentSieve(c(30, 125, 180, 500, 1000), ordered = TRUE)

# USDA system, flat size classes
fragmentSieve(c(30, 125, 180, 500, 1000), flat = TRUE)

# alternative classification systems
fragmentSieve(c(30, 125, 180, 500, 1000), sys = 'usda')
fragmentSieve(c(30, 125, 180, 500, 1000), sys = 'international')
fragmentSieve(c(30, 125, 180, 500, 1000), sys = 'unified')
fragmentSieve(c(30, 125, 180, 500, 1000), sys = 'aashto')
fragmentSieve(c(30, 125, 180, 500, 1000), sys = 'mod.wentworth')

# custom fragment labels / diameter
fragmentSieve(
  c(30, 125, 180, 500, 1000),
  sieves = c(clumps = 50, chunks = 300, blocks = 100000)
)

# unnamed sieves, generic labels used
fragmentSieve(c(10, 50), sieves = c(30, 70))

fragmentSieve(c(10, 50), sieves = c(30, 70), ordered = TRUE)
 
}
\references{
Soil Science Division Staff. 2017. Soil survey manual. C. Ditzler, K. Scheffe, and H.C. Monger (eds.). USDA Handbook 18. Government Printing Office, Washington, D.C.
}
\seealso{
\code{\link[=fragmentClasses]{fragmentClasses()}}
}
