% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipRepo.R
\name{zipLocalRepo}
\alias{zipLocalRepo}
\alias{zipRemoteRepo}
\title{Create a zip Archive From an Existing Repository}
\usage{
zipLocalRepo(repoDir = aoptions("repoDir"), repoTo = getwd(),
  zipname = "repository.zip")

zipRemoteRepo(repoTo = getwd(), user = aoptions("user"),
  repo = aoptions("repo"), branch = "master",
  subdir = aoptions("subdir"), repoType = aoptions("repoType"),
  zipname = "repository.zip")
}
\arguments{
\item{repoDir}{A character that specifies the directory of the Repository which
will be zipped.}

\item{repoTo}{A character that specifies the directory in which there
will be created zip archive from \code{Repository} stored in \code{repoDir} or Remote directory.
By default set to working directory (\code{getwd()}).}

\item{zipname}{A character that specifies name of the zipped repository.
It is assumed that this file does not exist or does not contain backpack.db file.
An attempt to override will produce an error.}

\item{user}{While working with the Remote repository. A character containing
a name of the Remote user on whose account the \code{repo} is created.
By default set to \code{NULL} - see \code{Note}.}

\item{repo}{While working with the Remote repository. A character containing
a name of the Remote repository on which the Repository, which is to be zipped, is archived.
By default set to \code{NULL} - see \code{Note}.}

\item{branch}{While working with the Remote repository. A character containing a name of the
Remote repository's branch on which Repository, which is to be zipped, is archived.
Default \code{branch} is \code{master}.}

\item{subdir}{While working with a Remote repository. A character containing a name of
a directory on Remote repository on which the Repository, which is to be zipped, is stored.
If the Repository is stored in the main folder on the Remote repository, this should be set 
to FALSE as default.}

\item{repoType}{A character containing a type of the remote repository. Currently it can be 'Remote' or 'bitbucket'.}
}
\description{
\code{zipLocalRepo} and \code{zipRemoteRepo} create a zip archive from an
existing \link{Repository}. \code{zipLocalRepo} zips local \code{Repository},
\code{zipRemoteRepo} zips \code{Repository} stored on Github.
}
\note{
The function might not work if \code{Rtools} are not installed.
To solve this problem follow these \href{https://CRAN.R-project.org/package=openxlsx/vignettes/Introduction.pdf}{Instructions.}

If \code{repo} and \code{user} are set to \code{NULL} (as default) in Github mode then global parameters
set in \link{setRemoteRepo} function are used.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{
# objects preparation
\dontrun{
# data.frame object
data(iris)

# ggplot/gg object
library(ggplot2)
df <- data.frame(gp = factor(rep(letters[1:3], each = 10)),y = rnorm(30))
library(plyr)
ds <- ddply(df, .(gp), summarise, mean = mean(y), sd = sd(y))
myplot123 <- ggplot(df, aes(x = gp, y = y)) +
  geom_point() +  geom_point(data = ds, aes(y = mean),
               colour = 'red', size = 3)
               
# lm object                
model <- lm(Sepal.Length~ Sepal.Width + Petal.Length + Petal.Width, data= iris)

# Local version

exampleRepoDir <- tempfile()
createLocalRepo( repoDir = exampleRepoDir )
saveToLocalRepo( myplot123, repoDir=exampleRepoDir )
saveToLocalRepo( iris, repoDir=exampleRepoDir )
saveToLocalRepo( model, repoDir=exampleRepoDir )


 
zipLocalRepo( exampleRepoDir )

deleteLocalRepo( exampleRepoDir, TRUE)

rm( exampleRepoDir )

# Remote version

zipRemoteRepo( user="MarcinKosinski", 
repo="Museum", branch="master", subdir="ex1" )

zipRemoteRepo( user="pbiecek", repo="archivist", repoTo = getwd( ) )

}

}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearchLocal}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{atrace}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}}

Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearchLocal}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{atrace}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}, Przemyslaw Biecek
}
\concept{archivist}
