% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{format_coords}
\alias{format_coords}
\alias{format_polygon_coords}
\alias{format_line_coords}
\alias{format_multipoint_coords}
\alias{format_point_coords}
\alias{format_envelope_coords}
\title{Convert coordinates from an 'sf' object to formatted well-known text}
\usage{
format_polygon_coords(sf_obj, crs = 4326)

format_line_coords(sf_obj, crs = 4326)

format_multipoint_coords(sf_obj, crs = 4326)

format_point_coords(sf_obj, crs = 4326)

format_envelope_coords(sf_obj, crs = 4326)

format_coords(sf_obj, geom_type, crs = 4326)
}
\arguments{
\item{sf_obj}{An sf object}

\item{crs}{The coordinate reference system. Defaults to 4326}

\item{geom_type}{Either "points", "paths", or "rings". Choose wisely}
}
\value{
String of well known text
}
\description{
Use this function to convert the coordinates of a sf polygon object to
a string of well known text. The output can be passed to an ArcGIS REST
API to perform a spatial query.
}
\details{
Spatial queries from an ArcGIS REST API require specific text inputs
formatted in a way called well-known text (WKT). ArcGIS REST APIs have their
own syntax for how the text is taken. These functions will format sf objects
in the correct way to be able to make spatial queries from a ArcGIS REST
API
}
\examples{
mke_polygon_coords <- format_polygon_coords(mke_county)
}
