% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lARFIMAwTF.R
\name{lARFIMAwTF}
\alias{lARFIMAwTF}
\title{Exact log-likelihood of a long memory model with a transfer function model
and series included}
\usage{
lARFIMAwTF(z, phi = numeric(0), theta = numeric(0), dfrac = numeric(0),
  phiseas = numeric(0), thetaseas = numeric(0), dfs = numeric(0),
  H = numeric(0), Hs = numeric(0), alpha = numeric(0),
  alphas = numeric(0), xr = numeric(0), r = numeric(0), s = numeric(0),
  b = numeric(0), delta = numeric(0), omega = numeric(0), period = 0,
  useC = 3, meanval = 0)
}
\arguments{
\item{z}{A vector or (univariate) time series object, assumed to be (weakly)
stationary.}

\item{phi}{The autoregressive parameters in vector form.}

\item{theta}{The moving average parameters in vector form.  See Details for
differences from \code{\link{arima}}.}

\item{dfrac}{The fractional differencing parameter.}

\item{phiseas}{The seasonal autoregressive parameters in vector form.}

\item{thetaseas}{The seasonal moving average parameters in vector form.  See
Details for differences from \code{\link{arima}}.}

\item{dfs}{The seasonal fractional differencing parameter.}

\item{H}{The Hurst parameter for fractional Gaussian noise (FGN).  Should
not be mixed with \code{dfrac} or \code{alpha}: see "Details".}

\item{Hs}{The Hurst parameter for seasonal fractional Gaussian noise (FGN).
Should not be mixed with \code{dfs} or \code{alphas}: see "Details".}

\item{alpha}{The decay parameter for power-law autocovariance (PLA) noise.
Should not be mixed with \code{dfrac} or \code{H}: see "Details".}

\item{alphas}{The decay parameter for seasonal power-law autocovariance
(PLA) noise.  Should not be mixed with \code{dfs} or \code{Hs}: see
"Details".}

\item{xr}{The regressors in vector form}

\item{r}{The order of the delta(s)}

\item{s}{The order of the omegas(s)}

\item{b}{The backshifting to be done}

\item{delta}{Transfer function parameters as in Box, Jenkins, and Reinsel.
Corresponds to the "autoregressive" part of the dynamic regression.}

\item{omega}{Transfer function parameters as in Box, Jenkins, and Reinsel.
Corresponds to the "moving average" part of the dynamic regression: note
that omega_0 is not restricted to 1.  See "Details" for issues.}

\item{period}{The periodicity of the seasonal components.  Must be >= 2.}

\item{useC}{How much interfaced C code to use: an integer between 0 and 3.
The value 3 is strongly recommended. See "Details".}

\item{meanval}{If the mean is to be estimated dynamically, the mean.}
}
\value{
A log-likelihood value
}
\description{
Computes the exact log-likelihood of a long memory model with respect to a
given time series as well as a transfer fucntion model and series. This
function is not meant to be used directly.
}
\details{
Once again, this function should not be used externally.
}
\references{
Veenstra, J.Q. Persistence and Antipersistence:  Theory and
Software (PhD Thesis)
}
\author{
Justin Veenstra
}
\keyword{ts}
