% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{predicate-graph}
\alias{predicate-graph}
\alias{is_dag}
\title{Graph Predicates}
\usage{
is_dag(x)
}
\arguments{
\item{x}{An adjacency \code{\link{matrix}} to be tested.}
}
\value{
A \code{\link{logical}} scalar.
}
\description{
\code{is_dag} checks if a graph has a topological ordering (i.e. is a
directed acyclic graph) using Kahn's algorithm.
}
\references{
Kahn, A. B. (1962). Topological sorting of large networks.
 \emph{Communications of the ACM}, 5(11), p. 558-562.
 DOI: \href{https://doi.org/10.1145/368996.369025}{10.1145/368996.369025}.
}
\seealso{
Other predicates: \code{\link{predicate-matrix}},
  \code{\link{predicate-numeric}},
  \code{\link{predicate-scalar}},
  \code{\link{predicate-trend}},
  \code{\link{predicate-type}},
  \code{\link{predicate-utils}}
}
\concept{predicates}
\keyword{internal}
