% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arkhe-package.R
\docType{package}
\name{arkhe-package}
\alias{arkhe-package}
\alias{_PACKAGE}
\alias{arkhe}
\title{arkhe: Representation of Archaeological Data}
\description{
\if{html}{\figure{logo.png}{options: align='right' alt='logo' width='120'}}

A collection of classes that represent
    archaeological data. This package provides a set of S4 classes that
    represent different special types of matrix (absolute/relative
    frequency, presence/absence data, co-occurrence matrix, etc.) upon
    which package developers can build subclasses. It also provides a set
    of generic methods (mutators and coercion mechanisms) and functions
    (e.g. summary statistics, predicates). In addition, a few classes of 
    general interest (e.g. that represent stratigraphic relationships) 
    are implemented.
}
\details{
\tabular{ll}{
\strong{Package:} \tab arkhe \cr
\strong{Type:} \tab Package \cr
\strong{Version:} \tab 0.4.0 \cr
\strong{License:} \tab GPL-3 \cr
\strong{Zenodo:} \tab \doi{10.5281/zenodo.3526659} \cr
}
}
\section{Package options}{

\code{arkhe} uses the following \code{\link[=options]{options()}} to configure behavior:
\itemize{
\item \code{arkhe.autodetect}: a \code{\link{logical}} scalar. Try to automatically assign
values to the corresponding slot of a \verb{*Matrix} object when coercing a
\code{data.frame}? Defaults to \code{TRUE}.
\item \code{arkhe.verbose}: a \code{\link{logical}} scalar. Should \R report extra information
on progress? Defaults to \code{TRUE}.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://packages.tesselle.org/arkhe/}
  \item \url{https://github.com/tesselle/arkhe}
  \item Report bugs at \url{https://github.com/tesselle/arkhe/issues}
}

}
\author{
\strong{Full list of authors and contributors} (alphabetic order):

\tabular{ll}{
Nicolas Frerebeau \tab \emph{Université Bordeaux Montaigne, France} \cr
Brice Lebrun \tab \emph{Université Bordeaux Montaigne, France} \cr
}

\strong{Package maintainer}

Nicolas Frerebeau\cr
\email{nicolas.frerebeau@u-bordeaux-montaigne.fr}

IRAMAT-CRP2A (UMR 5060)\cr
Maison de l'Archéologie\cr
Université Bordeaux Montaigne\cr
F-33607 Pessac cedex\cr
France
}
\keyword{internal}
