% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/initialize.R
\docType{class}
\name{CompositionMatrix-class}
\alias{CompositionMatrix-class}
\alias{.CompositionMatrix}
\alias{CompositionMatrix}
\title{Relative Frequency Matrix}
\usage{
CompositionMatrix(data = 0, nrow = 1, ncol = 1, byrow = FALSE, dimnames = NULL)
}
\arguments{
\item{data}{an optional data vector (including a list or
    \code{\link[base]{expression}} vector).  Non-atomic classed \R objects are
    coerced by \code{\link[base]{as.vector}} and all attributes discarded.}

\item{nrow}{the desired number of rows.}

\item{ncol}{the desired number of columns.}

\item{byrow}{logical. If \code{FALSE} (the default) the matrix is
    filled by columns, otherwise the matrix is filled by rows.}

\item{dimnames}{A \code{\link[base]{dimnames}} attribute for the matrix:
    \code{NULL} or a \code{list} of length 2 giving the row and column
    names respectively.  An empty list is treated as \code{NULL}, and a
    list of length one as row names.  The list can be named, and the
    list names will be used as names for the dimensions.}
}
\description{
An S4 class to represent a relative frequency matrix (i.e. the fraction of
times a given datum occurs in a dataset).
}
\examples{
## Create an incidence (presence/absence) matrix
## Data will be coerced with as.logical()
A <- IncidenceMatrix(data = sample(0:1, 100, TRUE, c(1, 1/3)), nrow = 20)
## Create a count data matrix
B <- CountMatrix(data = sample(0:10, 100, TRUE), nrow = 20)

## Access
dim(B) # Get the matrix dimensions
row(B) # Get the row indexes
col(B, as.factor = TRUE) # Get the column indexes
nrow(B) # Get the number of rows
ncol(B) # Get the number of columns
dimnames(B) # Get the dimension names
rownames(B) <- LETTERS[1:20] # Set the row names
rownames(B) # Get the rownames
colnames(B) <- letters[21:25] # Set the column names
colnames(B) # Get the column names

## Subset
B[[1, 1]] # Get the first value
B[1] # Get the first value
B[, ] # Get all values
B[1, , drop = FALSE] # Get the first row
B[, 1:3] # Get the first three column
}
\seealso{
\code{\link[=as_composition]{as_composition()}}

Other classes: 
\code{\link{CountMatrix-class}},
\code{\link{DataMatrix}},
\code{\link{IncidenceMatrix-class}},
\code{\link{OccurrenceMatrix-class}},
\code{\link{StratigraphicMatrix-class}},
\code{\link{coerce}()}
}
\author{
N. Frerebeau
}
\concept{classes}
