% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{assert_type}
\alias{assert_type}
\alias{assert_scalar}
\alias{assert_function}
\title{Check Data Types}
\usage{
assert_type(x, expected, allow_empty = TRUE, allow_null = FALSE)

assert_scalar(x, expected)

assert_function(x)
}
\arguments{
\item{x}{An object to be checked.}

\item{expected}{A \code{\link{character}} string specifying the expected
type. It must be one of "\code{list}", "\code{atomic}", "\code{vector}", "\code{numeric}",
"\code{integer}", "\code{double}", "\code{character}" or "\code{logical}".}

\item{allow_empty}{A \code{\link{logical}} scalar: should \link[=is_empty]{empty} object be
allowed?}

\item{allow_null}{A \code{\link{logical}} scalar: should \code{NULL} object be ignored?}
}
\value{
Throws an error, if any, and returns \code{x} invisibly otherwise.
}
\description{
Check Data Types
}
\seealso{
Other checking methods: 
\code{\link{assert_constant}()},
\code{\link{assert_dim}()},
\code{\link{assert_empty}()},
\code{\link{assert_infinite}()},
\code{\link{assert_length}()},
\code{\link{assert_lower}()},
\code{\link{assert_missing}()},
\code{\link{assert_names}()},
\code{\link{assert_numeric}},
\code{\link{assert_package}()},
\code{\link{assert_square}()},
\code{\link{assert_unique}()}
}
\author{
N. Frerebeau
}
\concept{checking methods}
