% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{predicate-utils}
\alias{predicate-utils}
\alias{has_length}
\alias{is_empty}
\alias{has_names}
\alias{has_missing}
\alias{has_infinite}
\alias{is_unique}
\alias{has_duplicates}
\title{Utility Predicates}
\usage{
has_length(x, n = NULL)

is_empty(x)

has_names(x, names = NULL)

has_missing(x)

has_infinite(x)

is_unique(x, tolerance = sqrt(.Machine$double.eps), na.rm = FALSE)

has_duplicates(x)
}
\arguments{
\item{x}{A \code{\link{vector}} to be tested.}

\item{n}{A length-one \code{\link{numeric}} vector specifying the length to test \code{x}
with. If \code{NULL}, returns \code{TRUE} if \code{x} has length greater than zero, and
\code{FALSE} otherwise.}

\item{names}{A \code{\link{character}} vector specifying the names to test \code{x}
with. If \code{NULL}, returns \code{TRUE} if \code{x} has names, and \code{FALSE} otherwise.}

\item{tolerance}{A \code{\link{numeric}} scalar giving the tolerance to check within
(for \code{numeric} vector).}

\item{na.rm}{A \code{\link{logical}} scalar: should missing values (including \code{NaN})
be omitted?}
}
\value{
A \code{\link{logical}} scalar.
}
\description{
\itemize{
\item \code{is_empty()} checks is an object is empty (any zero-length dimensions).
\item \code{has_length()} checks how long is an object.
\item \code{has_names()} checks if an object is named.
\item \code{has_duplicates()} checks if an object has duplicated elements.
\item \code{has_missing()} and \code{has_infinite()} check if an object contains missing
or infinite values.
}
}
\seealso{
Other predicates: 
\code{\link{is_scalar}},
\code{\link{predicate-matrix}},
\code{\link{predicate-numeric}},
\code{\link{predicate-trend}},
\code{\link{predicate-type}}
}
\concept{predicates}
