\name{matching}
\alias{matching}

\title{Matching}

\description{
Function for processing matching with propensity score 
}

\usage{
matching(z, score)
}

\arguments{
  \item{z}{vector of indicators for treatment or control.}
  
  \item{score}{vector of the propensity scores in the same order as z.}
}

\details{Function for matching each treatment unit in turn 
    the control unit (not previously chosen) with the 
    closest propensity score }

\value{
The function returns a vector of indices that the corresponding 
unit is matched to. 0 means matched to nothing.}
 
\references{Andrew Gelman and Jennifer Hill, Data Analysis Using 
Regression and Multilevel/Hierarchical Models, Cambridge University Press, 2006.}

\author{Jeniffer Hill \email{jh1030@columbia.edu};
        Yu-Sung Su \email{ys463@columbia.edu}
}

\seealso{\code{\link{balanceplot}}
        }

\examples{
data(lalonde)
attach(lalonde)
fit <- glm(treat ~ re74 + re75 + educ + black + hisp + married 
               + nodegr + u74 + u75, family=binomial(link="logit"))
pscores <- predict(fit, type="link")
matches <- matching(z=lalonde$treat, score=pscores)
matched <- lalonde[matches$matched,]  
balanceplot(lalonde, matched, fit)
}

\keyword{models}
\keyword{methods}
