% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariables.R
\name{covariables}
\alias{covariables}
\title{concatenation of the rownames of X and of the response vector Y.}
\usage{
covariables(X, Y)
}
\arguments{
\item{X}{the matrix (or data.frame) of covariates, dimension n*p (n is the sample size, p the number of covariates). X must have rownames, which are the names of the n subjects (i.e. the user ID of the n subjects).}

\item{Y}{the vector of the response, length n.}
}
\value{
a data.frame with dimension n*2: the first column gives the names of the subjects, and the second column is Y.
}
\description{
concatenation of the rownames of X and of the response vector Y.
}
\details{
internal function. Concatenation of the rownames of X (X is the matrix n*p of the covariates), and of the response vector Y. X must have rownames, which are the names of the n subjects (i.e. the user ID of the n subjects).
}
\examples{
X<-matrix(rnorm(50),nrow=10)
rownames(X)<-letters[1:10]
covariables(X, 1:10)
}
