% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/5_SimulateModels.R
\name{OpenNetwork}
\alias{OpenNetwork}
\title{Obtains the main characteristics of an Open Network model by simulation}
\usage{
OpenNetwork(arrivalDistribution = c(Exp(20), Exp(30)),
  serviceDistribution = c(Exp(100), Exp(25)), s = c(1, 2),
  p = matrix(c(0.2, 0.25, 0.1, 0), nrow = 2, ncol = 2), staClients = 100,
  transitions = 1000, historic = FALSE, nsim = 10, nproc = 1)
}
\arguments{
\item{arrivalDistribution}{Vector indicating the arrival distribution at each node (Each element must be an object of S4-class \code{distr}
defined in \pkg{distr} package or the no_distr() object)}

\item{serviceDistribution}{Vector indicating the service distribution at each node (Each element must be an object of S4-class \code{distr}
defined in \pkg{distr} package)}

\item{s}{Vector of servers in each node}

\item{p}{Routing matrix, where \eqn{p_{ij}} is the routing probability from node i to node j}

\item{staClients}{Number of customers used in the stabilization stage}

\item{transitions}{Number of transitions between nodes used in the simulation stage}

\item{historic}{Parameter to activate/deactivate the historic information}

\item{nsim}{Number of simulations}

\item{nproc}{Processors used in the simulation.}
}
\value{
Returns the next information of an Open network model:
\item{pn}{Vector of steady-state probabilities of having n customers in the system: \ifelse{latex}{\eqn{P_{n}}}{\out{<i>P<sub>n</sub></i>}}}
\item{l}{Vector of expected number of customers in the nodes: \eqn{L}}
\item{lq}{Vector of expected number of customers in the queues of the nodes: \ifelse{latex}{\eqn{L_{q}}}{\out{<i>L<sub>q</sub></i>}}}
\item{lqt}{Expected number of customers in all the queues: \ifelse{latex}{\eqn{L_{qTotal}}}{\out{<i>L<sub>qTotal</sub></i>}}}
\item{w}{Vector of expected waiting times in the nodes: \eqn{W}}
\item{wq}{Vector of expected waiting time in the queues of the nodes: \ifelse{latex}{\eqn{W_{q}}}{\out{<i>W<sub>q</sub></i>}}}
\item{eff}{System efficiency: \ifelse{latex}{\eqn{Eff = W/(W-W_{q})}}{\out{<i>Eff = W/(W-W<sub>q</sub></i>)}}}
\item{rho}{Traffic intensity: \eqn{\rho}}
\item{historic}{Optional parameter that stores the evolution of \ifelse{latex}{\eqn{L}, \eqn{L_q}, \eqn{W} and  \eqn{W_q}}{\out{L, L<sub>q</sub>, W, W<sub>q</sub>}}\emph{, Customers in the system, Rho and Elapsed time} during the simulation.}
}
\description{
Obtains the main characteristics of an Open Network model by simulation
}
\examples{
OpenNetwork(arrivalDistribution = c(Exp(20), no_distr()),
            serviceDistribution = c(Exp(100), Exp(25)),
            s                   = c(1,2),
            p                   = matrix(c(0.2, 0.25, 0.1, 0), nrow=2, ncol=2),
            staClients          = 10,
            transitions         = 100,
            nsim                = 10)
}
\seealso{
Other SimulatedModels: \code{\link{ClosedNetwork}};
  \code{\link{G_G_1_INF_H}}; \code{\link{G_G_1_K}};
  \code{\link{G_G_1}}; \code{\link{G_G_INF}};
  \code{\link{G_G_S_INF_H_Y}}; \code{\link{G_G_S_INF_H}};
  \code{\link{G_G_S_K}}; \code{\link{G_G_S}}
}

