% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsum.R
\name{modelsum}
\alias{modelsum}
\alias{print.modelsum}
\alias{print.modelsumList}
\title{Fit models over each of a set of independent variables with a response variable}
\usage{
modelsum(formula, family = "gaussian", data, adjust = NULL,
  na.action = na.modelsum, subset = NULL, weights = NULL,
  control = list(...), ...)

\method{print}{modelsum}(x, ...)

\method{print}{modelsumList}(x, ...)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}}; a symbolic description of the variables to be modeled.  See "Details" for more information.}

\item{family}{similar mechanism to \code{\link[stats]{glm}}, where the model to be fit is driven by the family, options include: binomial, gaussian, survival,
Poisson. Family options supported in glm can be in quotes or not, but survival requires quotes.}

\item{data}{an optional data.frame, list or environment (or object coercible by \code{\link[base]{as.data.frame}} to a data frame) containing the
variables in the model. If not found in \code{data}, the variables are taken from \code{environment(formula)}, typically
the environment from which \code{modelsum} is called.}

\item{adjust}{an object of class \code{\link{formula}}, listing variables to adjust by in all models. Specify as a one-sided formula,
like: \code{~Age+ Sex}.}

\item{na.action}{a function which indicates what should happen when the data contain \code{NA}s.
The default is set by the \code{na.modelsum} setting of \code{options}, and is \code{na.fail} if that is unset. The default is
to include observations with \code{NA}s in x variables, but remove those with \code{NA} in response variable.}

\item{subset}{an optional vector specifying a subset of observations (rows of \code{data}) to be used in the results.
Works as vector of logicals or an index.}

\item{weights}{an optional vector specifying the weights to apply to each data observation (rows of \code{data})}

\item{control}{control parameters to handle optional settings within \code{modelsum}. Control arguments can be passed to \code{modelsum},
which are carried forward to \code{modelsum.control} via the \code{...} argument. See \code{\link{modelsum.control}} for more details.}

\item{...}{additional arguments to be passed to internal \code{modelsum} functions. See "Details" for information.}

\item{x}{An object of class \code{'modelsum'}, or a list of such objects.}
}
\value{
An object with class \code{'modelsum'}, which is effectively a list with the variables from the right-side in x and the group variable in y.
  Then, each item in x has these:
  \item{fits}{a list with an item in X for each x in y ~ X + adjust variables}
  \item{family}{family used in glm}
  \item{Call}{Original call to modelsum}
  \item{control}{list of control parameters used in \code{modelsum}, and to be used in \code{\link{summary.modelsum}},
    the result of \code{\link{modelsum.control}}}
}
\description{
Fit and summarize models for each independent (x) variable with a response variable (y), with options to adjust by variables for each model.
}
\examples{
 
data(mockstudy)

tab1 <- modelsum(bmi ~ sex + age, data = mockstudy)
summary(tab1, text = TRUE)

tab2 <- modelsum(alk.phos ~ arm + ps + hgb, adjust = ~ age + sex,
                 family = "gaussian", data = mockstudy)
summary(tab2, text = TRUE)

summary(tab2, show.intercept = FALSE, text = TRUE)

tab2.df <- as.data.frame(tab2)

tab2.df[1:5,]
}
\author{
Jason Sinnwell, Patrick Votruba, Beth Atkinson, Gregory Dougherty, adapted from SAS Macro of the same name
}
\seealso{
\code{\link{modelsum.control}}, \code{\link{summary.modelsum}}, \code{\link{formulize}}
}

