% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.modelsum.R
\name{summary.modelsum}
\alias{summary.modelsum}
\alias{summary.modelsum}
\alias{print.summary.modelsum}
\title{Summarize a \code{modelsum} object.}
\usage{
\method{summary}{modelsum}(object, ..., labelTranslations = NULL,
  text = FALSE, title = NULL)

\method{print}{summary.modelsum}(x, ...)
}
\arguments{
\item{object}{A \code{\link{modelsum}} object.}

\item{...}{Other arguments; in \code{summary.modelsum}, these are passed to \code{\link{as.data.frame.modelsum}},
and in \code{print.summary.modelsum}, these are not used.}

\item{labelTranslations}{A named list (or vector) where the name is the label in the
output to be replaced in the pretty rendering of modelsum by the character
string value for the named element of the list, e.g.,
\code{list(age = "Age(years)")}.}

\item{text}{Logical, denoting whether to print out the text version.}

\item{title}{Title for the table, defaults to \code{NULL} (no title)}

\item{x}{An object of class \code{"summary.modelsum"}.}
}
\value{
An object of class \code{"summary.modelsum"}
}
\description{
Format the information in \code{object} as a table using Pandoc coding or plain text, and cat it to stdout.
}
\seealso{
\code{\link{modelsum}}, \code{\link{print.modelsum}}, \code{\link{as.data.frame.modelsum}}
}
\author{
Ethan Heinzen, based on code originally by Greg Dougherty
}
