% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.tableby.R
\name{summary.tableby}
\alias{summary.tableby}
\alias{summary.tableby}
\alias{as.data.frame.summary.tableby}
\alias{print.summary.tableby}
\title{The summary method for a \code{tableby} object}
\usage{
\method{summary}{tableby}(object, ..., labelTranslations = NULL,
  text = FALSE, title = NULL, pfootnote = FALSE)

\method{as.data.frame}{summary.tableby}(x, ..., text = x$text,
  pfootnote = x$pfootnote)

\method{print}{summary.tableby}(x, ..., format = "markdown")
}
\arguments{
\item{object}{An object of class \code{"tableby"}, made by the \code{\link{tableby}} function.}

\item{...}{For \code{summary.tableby}, other arguments passed to \code{\link{as.data.frame.tableby}}.
For \code{as.data.frame.summary.tableby}, "width" and "min.split" are passed to \code{\link{smart.split}}.
For \code{print}ing the summary object, these are passed to both \code{as.data.frame.summary.tableby} and
\code{\link[knitr]{kable}}.}

\item{labelTranslations}{A named list (or vector) where the name is the label in the
output to be replaced in the pretty rendering of tableby by the character string
value for the named element of the list, e.g., \code{list(age = "Age(Years)", meansd = "Mean(SD)")}.}

\item{text}{Logical, tell R to print the raw text version of the summary to the screen.
Default is \code{FALSE}, but recommended to be \code{TRUE} for interactive R session development. For
\code{as.data.frame}, this can be set to \code{NULL} to avoid changing the labels at all.}

\item{title}{Title that will appear on the top of the header in the pretty-table rendering
of the tableby object}

\item{pfootnote}{Logical, denoting whether to put footnotes describing the tests used to generate the p-values.}

\item{x}{An object of class \code{"summary.tableby"}.}

\item{format}{Passed to \code{\link[knitr]{kable}}: the format for the table. The default here is "markdown".
To use the default in \code{kable}, pass \code{NULL}.}
}
\value{
An object of class \code{summary.tableby}
}
\description{
The summary method for a \code{\link{tableby}} object, which is a pretty rendering of a \code{\link{tableby}}
object into a publication-quality results table in R Markdown, and can render well in text-only.
}
\examples{

set.seed(100)
## make 3+ categories for response
nsubj <- 90
mdat <- data.frame(Response=sample(c(1,2,3),nsubj, replace=TRUE),
                   Sex=sample(c("Male", "Female"), nsubj,replace=TRUE),
                   Age=round(rnorm(nsubj,mean=40, sd=5)),
                   HtIn=round(rnorm(nsubj,mean=65,sd=5)))

## allow default summaries on RHS variables
out <- tableby(Response ~ Sex + Age + HtIn, data=mdat)
summary(out, text=TRUE)
labels(out)
labels(out) <- c(Age="Age (years)", HtIn="Height (inches)")
summary(out, stats.labels=c(meansd="Mean-SD", q1q3 = "Q1-Q3"), text=TRUE)

}
\seealso{
\code{\link{tableby.control}}, \code{\link{tableby}}
}
\author{
Ethan Heinzen, based on code by Gregory Dougherty, Jason Sinnwell, Beth Atkinson,
  adapted from SAS Macros written by Paul Novotny and Ryan Lennon
}
