% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIST.R
\name{LIST}
\alias{LIST}
\alias{LIST,itemMatrix-method}
\alias{LIST,transactions-method}
\alias{LIST,tidLists-method}
\title{List Representation for Objects Based on Class itemMatrix}
\usage{
LIST(from, ...)

\S4method{LIST}{itemMatrix}(from, decode = TRUE)

\S4method{LIST}{transactions}(from, decode = TRUE)

\S4method{LIST}{tidLists}(from, decode = TRUE)
}
\arguments{
\item{from}{the object to be converted into a list.}

\item{...}{further arguments.}

\item{decode}{a logical controlling whether the items/transactions are
decoded from the column numbers internally used by
\link{itemMatrix} to the names stored in the object
\code{from}.  The default behavior is to decode.}
}
\value{
a list primitive.
}
\description{
Provides the generic function \code{LIST()} and the methods to create a
list representation from objects of the classes \link{itemMatrix},
\link{transactions}, and \link{tidLists}.
}
\details{
Using \code{LIST()} with \code{decode = TRUE} is equivalent to the standard
coercion \code{as(x, "list")}.  \code{LIST} returns the object \code{from}
as a list of vectors.  Each vector represents one row of the
\link{itemMatrix} (e.g., items in a transaction).
}
\examples{
data(Adult)

### default coercion (same as as(Adult[1:5], "list"))
LIST(Adult[1:5])

### coercion without item decoding
LIST(Adult[1:5], decode = FALSE)
}
\seealso{
Other import/export: 
\code{\link{DATAFRAME}()},
\code{\link{pmml}},
\code{\link{read}},
\code{\link{write}()}
}
\author{
Michael Hahsler
}
\concept{import/export}
\keyword{manip}
