% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemsets.R
\docType{class}
\name{itemsets-class}
\alias{itemsets-class}
\alias{itemsets}
\alias{show,itemsets-method}
\alias{summary,itemsets-method}
\alias{summary.itemsets-class}
\alias{show,summary.itemsets-method}
\alias{length,itemsets-method}
\alias{nitems,itemsets-method}
\alias{labels,itemsets-method}
\alias{itemLabels,itemsets-method}
\alias{itemLabels<-,itemsets-method}
\alias{itemInfo,itemsets-method}
\alias{items,itemsets-method}
\alias{items<-,itemsets-method}
\alias{tidLists,itemsets-method}
\alias{coercion-itemsets}
\alias{coerce,itemsets,data.frame-method}
\title{Class itemsets --- A Set of Itemsets}
\usage{
itemsets(items, itemLabels = NULL, quality = data.frame())

\S4method{summary}{itemsets}(object, ...)

\S4method{length}{itemsets}(x)

\S4method{nitems}{itemsets}(x)

\S4method{labels}{itemsets}(object, ...)

\S4method{itemLabels}{itemsets}(object)

\S4method{itemLabels}{itemsets}(object) <- value

\S4method{itemInfo}{itemsets}(object)

\S4method{items}{itemsets}(x)

\S4method{items}{itemsets}(x) <- value

\S4method{tidLists}{itemsets}(x)
}
\arguments{
\item{items}{an \link{itemMatrix} or an object that can be converted using \code{\link[=encode]{encode()}}.}

\item{itemLabels}{item labels used for \code{encode()}.}

\item{quality}{a data.frame with quality information (one row per itemset).}

\item{object, x}{the object}

\item{...}{further argments}

\item{value}{replacement value}
}
\description{
The \code{itemsets} class represents a set of itemsets and the associated
quality measures.
}
\details{
Itemsets are usually created by calling an association rule mining algorithm
like \code{\link[=apriori]{apriori()}}.
To create itemsets manually, the itemMatrix for the items of the itemsets
can be created using \link{itemCoding}.  An example is in the Example
section below.

Mined itemsets sets contain several interest measures accessible
with the \code{quality()} method.  Additional measures can be
calculated via \code{\link[=interestMeasure]{interestMeasure()}}.
}
\section{Functions}{
\itemize{
\item \code{summary(itemsets)}: create a summary

\item \code{length(itemsets)}: get the number of itemsets.

\item \code{nitems(itemsets)}: get the number of items (columns) in the current encoding.

\item \code{labels(itemsets)}: get the itemset labels.

\item \code{itemLabels(itemsets)}: get the item labels.

\item \code{itemLabels(itemsets) <- value}: replace the item labels.

\item \code{itemInfo(itemsets)}: get item info data.frame.

\item \code{items(itemsets)}: get items as an itemMatrix.

\item \code{items(itemsets) <- value}: with a different itemMatrix.

\item \code{tidLists(itemsets)}: get tidLists stored in the object (if any).

}}
\section{Slots}{

\describe{
\item{\code{items}}{an \link{itemMatrix} object representing the itemsets.}

\item{\code{tidLists}}{a \link{tidLists} or \code{NULL}.}

\item{\code{quality}}{a data.frame with quality information}

\item{\code{info}}{a list with mining information.}
}}

\section{Objects from the Class}{
 Objects are the result of calling the
functions \code{\link[=apriori]{apriori()}} (e.g., with \code{target = "frequent itemsets"} in the parameter list) or \code{\link[=eclat]{eclat()}}.

Objects can also
be created by calls of the form \code{new("itemsets", ...)}
or by using the constructor function
\code{itemsets()}.
}

\section{Coercions}{

\itemize{
\item \code{as("itemsets", "data.frame")}
}
}

\examples{
data("Adult")

## Mine frequent itemsets with Eclat.
fsets <- eclat(Adult, parameter = list(supp = 0.5))

## Display the 5 itemsets with the highest support.
fsets.top5 <- sort(fsets)[1:5]
inspect(fsets.top5)

## Get the itemsets as a list
as(items(fsets.top5), "list")

## Get the itemsets as a binary matrix
as(items(fsets.top5), "matrix")

## Get the itemsets as a sparse matrix, a ngCMatrix from package Matrix.
## Warning: for efficiency reasons, the ngCMatrix you get is transposed
as(items(fsets.top5), "ngCMatrix")

## Manually create itemsets with the item coding in the Adult dataset
## and calculate some interest measures
twoitemsets <- itemsets(
  items = list(
    c("age=Young", "relationship=Unmarried"),
    c("age=Old")
  ), itemLabels = Adult)

quality(twoitemsets) <- data.frame(support = interestMeasure(twoitemsets,
  measure = c("support"), transactions = Adult))

inspect(twoitemsets)
}
\seealso{
Superclass: \link{associations}

Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\keyword{classes}
