% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{sets}
\alias{sets}
\alias{setOperations}
\alias{union.itemMatrix}
\alias{union.associations}
\alias{union,associations-method}
\alias{union,itemMatrix-method}
\alias{intersect.itemMatrix}
\alias{intersect.associations}
\alias{intersect,associations-method}
\alias{intersect,itemMatrix-method}
\alias{setequal.itemMatrix}
\alias{setequal.associations}
\alias{setequal,associations-method}
\alias{setequal,itemMatrix-method}
\alias{setdiff.itemMatrix}
\alias{setdiff.associations}
\alias{setdiff,associations-method}
\alias{setdiff,itemMatrix-method}
\alias{is.element.itemMatrix}
\alias{is.element.associations}
\alias{is.element,associations-method}
\alias{is.element,itemMatrix-method}
\title{Set Operations}
\usage{
\method{union}{itemMatrix}(x, y, ...)

\method{union}{associations}(x, y, ...)

\S4method{union}{associations}(x, y, ...)

\S4method{union}{itemMatrix}(x, y, ...)

\method{intersect}{itemMatrix}(x, y, ...)

\method{intersect}{associations}(x, y, ...)

\S4method{intersect}{associations}(x, y, ...)

\S4method{intersect}{itemMatrix}(x, y, ...)

\method{setequal}{itemMatrix}(x, y, ...)

\method{setequal}{associations}(x, y, ...)

\S4method{setequal}{associations}(x, y, ...)

\S4method{setequal}{itemMatrix}(x, y, ...)

\method{setdiff}{itemMatrix}(x, y, ...)

\method{setdiff}{associations}(x, y, ...)

\S4method{setdiff}{associations}(x, y, ...)

\S4method{setdiff}{itemMatrix}(x, y, ...)

\method{is.element}{itemMatrix}(el, set, ...)

\method{is.element}{associations}(el, set, ...)

\S4method{is.element}{associations}(el, set, ...)

\S4method{is.element}{itemMatrix}(el, set, ...)
}
\arguments{
\item{x, y, el, set}{sets of associations or itemMatrix objects.}

\item{...}{Other arguments are unused.}
}
\value{
\code{union()}, \code{intersect()}, \code{setequal()} and \code{setdiff()}
return an object of the same class as \code{x} and \code{y}.

\code{is.element()} returns a logic vector of length \code{el} indicating for
each element if it is included in \code{set}.
}
\description{
Provides the generic functions and the methods for the set operations
\code{union()}, \code{intersect()}, \code{setequal()}, \code{setdiff()} and
\code{is.element()} on sets of \link{associations} (e.g., \link{rules}, \link{itemsets}) and
\link{itemMatrix}.
}
\details{
Technical note: All S4 methods for set operations are defined for the class name
\code{"ANY"} in the signature, so they should work for all S4 classes for
which the following methods are available: \code{\link[=match]{match()}}, \code{\link[=length]{length()}} and
\code{\link[=unique]{unique()}}.
}
\examples{
data("Adult")

## mine some rules
r <- apriori(Adult)

## take 2 subsets
r1 <- r[1:10]
r2 <- r[6:15]

union(r1, r2)
intersect(r1, r2)
setequal(r1, r2)

}
\seealso{
Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{crossTable}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemFrequency}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\concept{itemMatrix and transactions functions}
\keyword{manip}
