% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.generator.R
\name{is.generator}
\alias{is.generator}
\alias{is.generator,itemsets-method}
\title{Find Generator Itemsets}
\usage{
is.generator(x)

\S4method{is.generator}{itemsets}(x)
}
\arguments{
\item{x}{a set of itemsets.}
}
\value{
a logical vector with the same length as \code{x} indicating for
each element in \code{x} if it is a generator itemset.
}
\description{
Provides the generic function and the method `is.generator() for
finding generator itemsets. Generators are part of concise representations
for frequent itemsets.  A generator in a set of itemsets is an itemset that
has no subset with the same support (Liu et al, 2008). Note that the empty
set is by definition a generator, but it is typically not stored in the
itemsets in \pkg{arules}.
}
\examples{
# Example from Liu et al (2008)
trans_list <- list(
  t1 = c("a", "b", "c"),
  t2 = c("a", "b", "c", "d"),
  t3 = c("a", "d"),
  t4 = c("a", "c")
)

trans <- transactions(trans_list)
its <- apriori(trans, support = 1 / 4, target = "frequent itemsets")

is.generator(its)

}
\references{
Yves Bastide, Niolas Pasquier, Rafik Taouil, Gerd Stumme, Lotfi
Lakhal (2000). Mining Minimal Non-redundant Association Rules Using Frequent
Closed Itemsets. In \emph{International Conference on Computational Logic},
Lecture Notes in Computer Science (LNCS 1861). pages 972--986.
\doi{10.1007/3-540-44957-4_65}

Guimei Liu, Jinyan Li, Limsoon Wong (2008). A new concise representation of
frequent itemsets using generators and a positive border.
\emph{Knowledge and Information Systems} 17(1):35-56.
\doi{10.1007/s10115-007-0111-5}
}
\seealso{
Other postprocessing: 
\code{\link{is.closed}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()}

Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\concept{postprocessing}
\keyword{models}
