/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class AssocRuleMining
extends JFrame {
    protected short[][] dataArray = null;
    protected String fileName = null;
    protected int numClasses = 0;
    protected boolean errorFlag = true;
    protected boolean inputFormatOkFlag = true;
    protected int numCols = 0;
    protected int numRows = 0;
    protected int numOneItemSets = 0;
    protected BufferedReader fileInput;
    protected File filePath = null;

    public AssocRuleMining(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.idArgument(stringArray[i]);
        }
        if (this.errorFlag) {
            this.CheckInputArguments();
        } else {
            this.outputMenu();
        }
    }

    public AssocRuleMining() {
    }

    protected void idArgument(String string) {
        if (string.charAt(0) == '-') {
            char c = string.charAt(1);
            string = string.substring(2, string.length());
            switch (c) {
                case 'F': {
                    this.fileName = string;
                    break;
                }
                case 'N': {
                    this.numClasses = Integer.parseInt(string);
                    break;
                }
                default: {
                    System.out.println("INPUT ERROR: Unrecognised command line  argument -" + c + string);
                    this.errorFlag = false;
                    break;
                }
            }
        } else {
            System.out.println("INPUT ERROR: All command line arguments must commence with a '-' character (" + string + ")");
            this.errorFlag = false;
        }
    }

    protected void CheckInputArguments() {
    }

    protected void checkFileName() {
        if (this.fileName == null) {
            System.out.println("INPUT ERROR: Must specify file name (-F)");
            this.errorFlag = false;
        }
    }

    protected void readFile() {
        try {
            this.inputFormatOkFlag = true;
            this.numRows = this.getNumberOfLines(this.fileName);
            if (this.inputFormatOkFlag) {
                this.dataArray = new short[this.numRows][];
                System.out.println("Reading input file: " + this.fileName);
                this.readInputDataSet();
            } else {
                System.out.println("Error reading file: " + this.fileName + "\n");
            }
        }
        catch (IOException iOException) {
            System.out.println("Error reading File");
            this.closeFile();
            System.exit(1);
        }
    }

    protected int getNumberOfLines(String string) throws IOException {
        int n = 0;
        if (this.filePath == null) {
            this.openFileName(string);
        } else {
            this.openFilePath();
        }
        String string2 = this.fileInput.readLine();
        while (string2 != null) {
            this.checkLine(n + 1, string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n2 = stringTokenizer.countTokens();
            if (n2 == 0) break;
            ++n;
            string2 = this.fileInput.readLine();
        }
        this.closeFile();
        return n;
    }

    protected void checkLine(int n, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i)) || Character.isWhitespace(string.charAt(i))) continue;
            JOptionPane.showMessageDialog(null, "FILE INPUT ERROR:\ncharcater on line " + n + " is not a digit or white space");
            this.inputFormatOkFlag = false;
            break;
        }
    }

    public void readInputDataSet() throws IOException {
        StringTokenizer stringTokenizer;
        int n;
        int n2 = 0;
        if (this.filePath == null) {
            this.openFileName(this.fileName);
        } else {
            this.openFilePath();
        }
        String string = this.fileInput.readLine();
        while (string != null && (n = (stringTokenizer = new StringTokenizer(string)).countTokens()) != 0) {
            short[] sArray = this.binConversion(stringTokenizer, n);
            if (sArray != null) {
                int n3 = sArray.length;
                this.dataArray[n2] = new short[n3];
                for (int i = 0; i < n3; ++i) {
                    this.dataArray[n2][i] = sArray[i];
                }
            } else {
                this.dataArray[n2] = null;
            }
            ++n2;
            string = this.fileInput.readLine();
        }
        this.closeFile();
    }

    protected boolean checkOrdering() {
        boolean bl = true;
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (this.checkLineOrdering(i + 1, this.dataArray[i])) continue;
            bl = false;
        }
        return bl;
    }

    private boolean checkLineOrdering(int n, short[] sArray) {
        for (int i = 0; i < sArray.length - 1; ++i) {
            if (sArray[i] < sArray[i + 1]) continue;
            JOptionPane.showMessageDialog(null, "FILE FORMAT ERROR:\nAttribute data in line " + n + " not in numeric order");
            return false;
        }
        return true;
    }

    protected void countNumCols() {
        int n = 0;
        for (int i = 0; i < this.dataArray.length; ++i) {
            int n2 = this.dataArray[i].length - 1;
            if (this.dataArray[i][n2] <= n) continue;
            n = this.dataArray[i][n2];
        }
        this.numOneItemSets = this.numCols = n;
    }

    protected void openFileName(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            this.fileInput = new BufferedReader(fileReader);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error Opening File", "Error: ", 0);
        }
    }

    private void openFilePath() {
        try {
            FileReader fileReader = new FileReader(this.filePath);
            this.fileInput = new BufferedReader(fileReader);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error Opening File", "Error: ", 0);
        }
    }

    protected void closeFile() {
        if (this.fileInput != null) {
            try {
                this.fileInput.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Error Closing File", "Error: ", 0);
            }
        }
    }

    protected short[] binConversion(StringTokenizer stringTokenizer, int n) {
        short[] sArray = null;
        for (int i = 0; i < n; ++i) {
            short s = new Short(stringTokenizer.nextToken());
            sArray = this.realloc1(sArray, s);
        }
        return sArray;
    }

    protected short[] reallocInsert(short[] sArray, short s) {
        if (sArray == null) {
            short[] sArray2 = new short[]{s};
            return sArray2;
        }
        int n = sArray.length;
        short[] sArray3 = new short[n + 1];
        for (int i = 0; i < n; ++i) {
            if (s < sArray[i]) {
                sArray3[i] = s;
                for (int j = i + 1; j < sArray3.length; ++j) {
                    sArray3[j] = sArray[j - 1];
                }
                return sArray3;
            }
            sArray3[i] = sArray[i];
        }
        sArray3[sArray3.length - 1] = s;
        return sArray3;
    }

    protected short[] realloc1(short[] sArray, short s) {
        if (sArray == null) {
            short[] sArray2 = new short[]{s};
            return sArray2;
        }
        int n = sArray.length;
        short[] sArray3 = new short[n + 1];
        for (int i = 0; i < n; ++i) {
            sArray3[i] = sArray[i];
        }
        sArray3[i] = s;
        return sArray3;
    }

    protected short getLastElement(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        return sArray[sArray.length - 1];
    }

    protected boolean isEqual(short[] sArray, short[] sArray2) {
        if (sArray2 == null) {
            return false;
        }
        int n = sArray.length;
        int n2 = sArray2.length;
        if (n != n2) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (sArray[i] == sArray2[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean isSubset(short[] sArray, short[] sArray2) {
        if (sArray == null) {
            return true;
        }
        if (sArray2 == null) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (!this.notMemberOf(sArray[i], sArray2)) continue;
            return false;
        }
        return true;
    }

    protected boolean notMemberOf(short s, short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            if (s < sArray[i]) {
                return true;
            }
            if (s != sArray[i]) continue;
            return false;
        }
        return true;
    }

    protected short[] copyItemSet(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        short[] sArray2 = new short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            sArray2[i] = sArray[i];
        }
        return sArray2;
    }

    public void outputDataArray() {
        System.out.println("DATA SET\n--------");
        for (int i = 0; i < this.dataArray.length; ++i) {
            this.outputItemSet(this.dataArray[i]);
            System.out.println();
        }
    }

    protected void outputItemSet(short[] sArray) {
        if (sArray == null) {
            System.out.print(" null ");
        } else {
            int n = 0;
            for (int i = 0; i < sArray.length; ++i) {
                if (n == 0) {
                    ++n;
                    System.out.print(" {");
                } else {
                    System.out.print(" ");
                }
                System.out.print(sArray[i]);
            }
            System.out.print("} ");
        }
    }

    public void outputDataArraySize() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (this.dataArray[i] == null) continue;
            ++n;
            n2 += this.dataArray[i].length;
        }
        System.out.println("Number of columns  = " + this.numCols);
        System.out.println("Number of records  = " + n);
        System.out.println("Number of elements = " + n2);
        double d = (double)n2 / (double)(this.numCols * n);
        System.out.println("Data set density   = " + this.twoDecPlaces(d) + "%");
    }

    protected void outputMenu() {
        System.out.println();
        System.out.println("-F  = File name");
        System.out.println("-N  = Number of classes (Optional)");
        System.out.println();
        System.exit(1);
    }

    protected void outputSettings() {
    }

    public double outputDuration(double d, double d2) {
        double d3 = (d2 - d) / 1000.0;
        System.out.println("Generation time = " + this.twoDecPlaces(d3) + " seconds (" + this.twoDecPlaces(d3 / 60.0) + " mins)");
        return d3;
    }

    protected double twoDecPlaces(double d) {
        int n = (int)((d + 0.005) * 100.0);
        d = (double)n / 100.0;
        return d;
    }
}

