% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asm.R
\name{print.summary.asm}
\alias{print.summary.asm}
\title{Print summary of the \code{asm} regression model}
\usage{
\method{print}{summary.asm}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  concise = FALSE,
  ...
)
}
\arguments{
\item{x}{summary.asm object}

\item{digits}{number of digits to print}

\item{signif.stars}{logical; if TRUE, 'significance stars' are printed}

\item{concise}{logical; if TRUE, the output is concise}

\item{...}{additional arguments to ensure compatibility with the generic function print()}
}
\value{
No return value
}
\description{
Prints the summary of a fitted \code{asm} regression model
}
\examples{
model = asm(mpg ~ cyl + hp + disp, data=mtcars)
print(summary(model))

}
