% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_files.R
\name{import_files}
\alias{import_files}
\title{Given a vector of filenames, append all files and return as one data.table using a user-defined function}
\usage{
import_files(filenames, folder = "", FUN = fread, warn_only = FALSE,
  multicore = FALSE, use.names = TRUE, fill = TRUE,
  mc.preschedule = FALSE, mc.cores = getOption("mc.cores", 2L), ...)
}
\arguments{
\item{filenames}{A character vector of filenames (specify full paths if you are checking files that are not in present working directory)}

\item{folder}{An optional character containing the folder name that contains the files you want to check (if used, do not include folderpath in the filenames characters). If not specified, will look in present working directory.}

\item{FUN}{function: The function that you want to use to import your data, e.g. read.csv, fread, read_dta, etc.}

\item{warn_only}{Boolean (T/F), whether to send a warning message as opposed to an error message if files are missing prior to import. Will only import the files that do exist.}

\item{multicore}{boolean, use lapply or mclapply (multicore = T) to loop over files in \emph{filenames} for import. Default=F.}

\item{use.names}{boolean, pass to the use.names option for \emph{rbindlist}}

\item{fill}{boolean, pass to the fill option for \emph{rbindlist}}

\item{mc.preschedule}{boolean, pass to the mc.preschedule option for \emph{mclapply} if multicore = T. Default = F.}

\item{mc.cores, }{pass to the mc.preschedule option for \emph{mclapply} if multicore = T. Default = mclapply default.}

\item{...}{named arguments of \emph{FUN} to pass to \emph{FUN}}
}
\value{
One data.table that contains all files in \emph{filenames}, combined together using rbindlist. 
        Returns an error if any file in \emph{filenames} does not exist
}
\description{
Given a character vector of filenames, check how many of them currently exist. 
Optionally, can keep checking for a specified amount of time, at a given frequency
}
\examples{
\dontrun{
 for(i in 1:3) {
   data <- CO2
   data$id_var <- i
   write.csv(data,file=paste0("file_",i,".csv"),row.names=FALSE)
 }
 filenames <- paste0("file_",c(1:3),".csv")
 import_files(filenames, FUN=fread)
 import_files(filenames, FUN=read.csv, stringsAsFactors=FALSE)
 import_files(filenames, FUN=fread, multicore=T, mc.cores=1) # Only if you have a multi-core system
}
}
