% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_create.R
\name{assert_create}
\alias{assert_create}
\title{Create an assertion function}
\usage{
assert_create(func, default_error_msg = NULL)
}
\arguments{
\item{func}{A function defining the assertion criteria. This function should
return a logical value (\code{TRUE} when assertion is passed or \code{FALSE} when it fails).
Alternatively, instead of returning FALSE, you can return a string which will act as the error message.
In this latter case, you don't need to supply a \code{default_error_msg}}

\item{default_error_msg}{A character string providing an error message in case
the assertion fails. Must be supplied if function \code{func} returns \code{FALSE} when assertion fails (as opposed to a string)
Can include the following special terms
\enumerate{
\item \code{{arg_name}} to refer to the name of the variable supplied to the assertion.
\item \code{{arg_value}} to refer to the value of the variable supplied to the assertion
\item \code{{code_to_evaluate}} to evaluate the code within the error message.
Replace \code{code_to_evaluate} with your code
\item \verb{\{.strong bold_text\}} to perform inline formatting. Replace \code{bold_text} with your text.
See \href{https://cli.r-lib.org/reference/inline-markup.html}{cli documentation} for details
}}
}
\value{
An assertion function.
}
\description{
This function creates an assertion function that can be used to check the
validity of an input.
All assertions provided with this package are created using either \code{\link[=assert_create]{assert_create()}} or \code{\link[=assert_create_chain]{assert_create_chain()}}
}
\examples{
#' # Create an assertion function that checks that a character string is all
# lower case
assert_character <- assert_create(
  is.character,
  "{arg_name} must be a character vector, not a {class(arg_value)}"
)

# Use the assertion function
try({
is_lower("hello") # Returns invisible TRUE
is_lower("Hello") # Aborts the function with the error message
})
}
\concept{assert_create}
