% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has-attributes.R
\name{has_any_attributes}
\alias{has_any_attributes}
\alias{has_no_attributes}
\title{Does the input have any attributes?}
\usage{
has_any_attributes(x, .xname = get_name_in_parent(x))

has_no_attributes(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{has_any_attributes} returns \code{TRUE} if \code{attributes(x)}
has length greater than zero. \code{has_attributes} returns a logical vector
that is \code{TRUE} whenever the specified attribute is not \code{NULL}.
}
\description{
Checks to see if the input has any attributes.
}
\note{
There are no corresponding \code{assert} functions, since they overlap 
too closely with the assertions for \code{\link{has_attributes}}.
}
\examples{
has_any_attributes(matrix())
has_no_attributes(data.frame())
}
\seealso{
\code{\link{has_attributes}} to check for specific attributes.
}
