% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-a-type.R, R/is-a-type.R
\name{assert_is_inherited_from}
\alias{assert_is_inherited_from}
\alias{is_inherited_from}
\title{Does the object inherit from some class?}
\usage{
assert_is_inherited_from(x, classes,
  severity = getOption("assertive.severity", "stop"))

is_inherited_from(x, classes, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Any R variable.}

\item{classes}{A character vector of classes.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{TRUE} if \code{x} inherits from at least one of the classes,
as determined by \code{\link[base]{inherits}}.
}
\description{
Checks to see if an object is inherited from any of the specified classes.
}
\examples{
x <- structure(1:5, class = c("foo", "bar"))
assert_is_inherited_from(x, c("foo", "baz"))
assertive.base::dont_stop(assert_is_inherited_from(x, c("Foo", "baz")))
}
\seealso{
\code{\link[base]{inherits}}, \code{\link[methods]{is}}, 
\code{\link[assertive.base]{is2}}
}

