% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-function.R, R/is-function.R
\name{assert_is_closure_function}
\alias{assert_is_builtin_function}
\alias{assert_is_closure_function}
\alias{assert_is_special_function}
\alias{is_builtin_function}
\alias{is_closure_function}
\alias{is_special_function}
\title{Is the input a closure, builtin or special function?}
\usage{
assert_is_closure_function(x, severity = getOption("assertive.severity",
  "stop"))

assert_is_builtin_function(x, severity = getOption("assertive.severity",
  "stop"))

assert_is_special_function(x, severity = getOption("assertive.severity",
  "stop"))

is_closure_function(x, .xname = get_name_in_parent(x))

is_builtin_function(x, .xname = get_name_in_parent(x))

is_special_function(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_internal_function} returns \code{TRUE} when the input is a 
closure function that calls \code{\link[base]{.Internal}}.  The 
\code{assert_*} function returns nothing but throw an error if the 
corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if the input is a closure, builtin or special function.
}
\examples{
# most functions are closures
is_closure_function(mean)
is_closure_function(lm)
is_closure_function(summary)

# builtin functions are typically math operators, low level math functions
# and commonly used functions
is_builtin_function(`*`)
is_builtin_function(cumsum)
is_builtin_function(is.numeric)

# special functions are mostly language features 
is_special_function(`if`)
is_special_function(`return`)
is_special_function(`~`)

# some failure messages
assertive.base::dont_stop({
assert_is_builtin_function(mean)
assert_is_builtin_function("mean")
})
}
\references{
There is some discussion of closure vs. builtin vs. special
functions in the Argument Evaluation section of R-internals.
\url{https://cran.r-project.org/doc/manuals/r-devel/R-ints.html#Argument-evaluation}
}
\seealso{
\code{\link[base]{is.function}} and its assertive wrapper
\code{\link{is_function}}.
\code{\link[base]{typeof}} is used to distinguish the three types 
of function.
}

