\name{assert_all_are_us_zip_codes}
\alias{assert_all_are_us_zip_codes}
\alias{assert_any_are_us_zip_codes}
\alias{is_us_zip_code}
\title{Is the string a valid US zip code?}
\usage{
  assert_all_are_us_zip_codes(x)

  assert_any_are_us_zip_codes(x)

  is_us_zip_code(x)
}
\arguments{
  \item{x}{Input to check.}
}
\value{
  \code{is_us_zip_code} returns \code{TRUE} if the input
  string contains a valid US zip code. The {assert_*}
  functions return nothing but throw an error when the
  \code{is_*} function returns \code{FALSE}.
}
\description{
  Checks that the input contains US zip codes.
}
\note{
  A valid zip code is considered to be 5 digits, or 5
  digits then a hyphen then 4 digits.  Unused area prefixes
  return FALSE, but the function doesn't guarantee that the
  zip code actually exists.  It should correctly return
  \code{TRUE} for genuine zip codes, and will weed out most
  badly formatted strings non-existent areas, but some
  non-existent codes may incorrectly return \code{TRUE}.
  If you need 100% accuracy, check against an up-to-date
  zip code base.
}
\examples{
zip_codes <- c(
  "90210",
  "20500",
  "22313-1450",  #5+4 style ok
  "223131450",   #fails, no hyphen
  "09901"        #fails, invalid area prefix
 )
is_us_zip_code(zip_codes)
assert_any_are_us_zip_codes(zip_codes)
\dontrun{
#The following code should throw an error.
assert_all_are_us_zip_codes(zip_codes)
}
}
\references{
  Regexes inferred from
  \url{https://en.wikipedia.org/wiki/ZIP_code} and
  \url{https://en.wikipedia.org/wiki/List_of_ZIP_code_prefixes}.
}

