% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/assert-is-type.R, R/is-type.R
\name{assert_is_call}
\alias{assert_is_call}
\alias{assert_is_expression}
\alias{assert_is_language}
\alias{assert_is_name}
\alias{assert_is_symbol}
\alias{is_call}
\alias{is_expression}
\alias{is_language}
\alias{is_name}
\alias{is_symbol}
\title{Is the input a language object?}
\usage{
assert_is_call(x)

assert_is_expression(x)

assert_is_language(x)

assert_is_name(x)

assert_is_symbol(x)

is_call(x, .xname = get_name_in_parent(x))

is_expression(x, .xname = get_name_in_parent(x))

is_language(x, .xname = get_name_in_parent(x))

is_name(x, .xname = get_name_in_parent(x))

is_symbol(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_call}, \code{is_expression}, \code{is_language},
\code{is_name} and \code{is_symbol} wrap the corresponding \code{is.*}
functions, providing more information on failure.  The \code{assert_*}
functions return nothing but throw an error if the corresponding
\code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if the input is a language object.
}
\note{
\code{is_name} and \code{is_symbol} are different names for
the same function.
}
\examples{
a_call <- call("sin", "pi")
assert_is_call(a_call)
assert_is_language(a_call)
an_expression <- expression(sin(pi))
assert_is_expression(an_expression)
assert_is_language(an_expression)
a_name <- as.name("foo")
assert_is_name(a_name)
assert_is_language(a_name)
#These examples should fail.
dont_stop(assert_is_language(function(){}))
}
\seealso{
\code{\link[base]{is.call}}, \code{\link[base]{is.expression}}
\code{\link[base]{is.language}} and \code{\link[base]{is.name}}.
}

