% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/assert-is-file.R, R/is-file.R
\name{assert_all_are_empty_files}
\alias{assert_all_are_empty_files}
\alias{assert_any_are_empty_files}
\alias{is_empty_file}
\title{Is a file empty?}
\usage{
assert_all_are_empty_files(x)

assert_any_are_empty_files(x)

is_empty_file(x)
}
\arguments{
\item{x}{Input to check.}
}
\value{
\code{is_empty_file} wraps \code{file.info}, retuning \code{TRUE}
when the input is a file that exists with size zero.
\code{assert_*_are_empty_files} return nothing but throws an error if
\code{is_empty_file} returns \code{FALSE}.
}
\description{
Checks to see if a file is empty.
}
\examples{
\dontrun{
tf <- tempfile()
file.create(tf)
is_empty_file(tf)
unlink(tf)
}
}
\seealso{
\code{\link[base]{file.info}}.
}

