% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/assert-is-empty-scalar.R, R/is-empty-scalar.R
\name{assert_is_empty_model}
\alias{assert_is_empty_model}
\alias{assert_is_non_empty_model}
\alias{is_empty_model}
\alias{is_non_empty_model}
\title{Is the input the empty model?}
\usage{
assert_is_empty_model(x)

assert_is_non_empty_model(x)

is_empty_model(x, .xname = get_name_in_parent(x))

is_non_empty_model(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_[non_]empty_model} returns \code{TRUE} if the input is an
[non] empty model.  (\code{has_terms} is used to determine that a variable
is a model object.)  The model is considered empty if there are no
factors and no intercept. The \code{assert_*} functions return nothing
but throw an error if the corresponding \code{is_*} function returns
\code{FALSE}.
}
\description{
Checks to see if the input is the empty model.
}
\examples{
assert_is_empty_model(lm(uptake ~ 0, CO2))
assert_is_non_empty_model(lm(uptake ~ conc, CO2))
assert_is_non_empty_model(lm(uptake ~ 1, CO2))
}
\seealso{
\code{\link[stats]{is.empty.model}} and \code{is_empty}.
}

