% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-type.R, R/is-type.R
\name{assert_is_environment}
\alias{assert_is_environment}
\alias{is_environment}
\title{Is the input an environment?}
\usage{
assert_is_environment(x)

is_environment(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_environment} wraps \code{is.environment}, providing more
information on failure.  \code{assert_is_environment} returns nothing
but throws an error if \code{is_environment} returns \code{FALSE}.
}
\description{
Checks to see if the input is an environment.
}
\examples{
assert_is_environment(new.env())
assert_is_environment(globalenv())
assert_is_environment(baseenv())
}
\seealso{
\code{\link[base]{is.environment}}.
}

