% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-other.R, R/is-other.R
\name{assert_is_if_condition}
\alias{assert_is_if_condition}
\alias{is_if_condition}
\title{Is suitable to be used as an if condition}
\usage{
assert_is_if_condition(x)

is_if_condition(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_if_condition} returns \code{TRUE} if the input is
scalar \code{TRUE} or \code{FALSE}.
}
\description{
Is suitable to be used as an if condition
}
\note{
\code{if} will try to do the right thing if you pass it a number
or a string, but this function assumes you want to do the right thing
and pass either \code{TRUE} or \code{FALSE}, maybe with some attributes.
}
\examples{
is_if_condition(TRUE)
is_if_condition(FALSE)
is_if_condition(NA)
is_if_condition(c(TRUE, FALSE))
is_if_condition("the truth")
# You can pass a number as a logical condition, but you shouldn't,
# so the next line returns FALSE.
is_if_condition(1)
dont_stop(assert_is_if_condition(raw(1)))
}

