% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{in_set}
\alias{in_set}
\title{Returns TRUE if value in set}
\usage{
in_set(..., allow.na = TRUE)
}
\arguments{
\item{...}{objects that make up the set}

\item{allow.na}{A logical indicating whether NAs (including NaNs)
should be permitted (default TRUE)}
}
\value{
A function that takes one value and returns TRUE
        if the value is in the set defined by the
        arguments supplied by \code{in_set} and FALSE
        otherwise
}
\description{
This function returns a predicate function that will take a single
value and return TRUE if the value is a member of the set of objects
supplied. This doesn't actually check the membership of anything--it
only returns a function that actually does the checking when called
with a value. This is a convenience function meant to return a
predicate function to be used in an \code{\link{assertr}} assertion.
}
\examples{
predicate <- in_set(3,4)
predicate(4)

## is equivalent to

in_set(3,4)(3)

# the remainder of division by 2 is always 0 or 1
rem <- 10 \%\% 2
in_set(0,1)(rem)

## this is meant to be used as a predicate in an assert statement
assert(mtcars, in_set(3,4,5), gear)

## or in a pipeline, like this was meant for

library(magrittr)

mtcars \%>\%
  assert(in_set(3,4,5), gear) \%>\%
  assert(in_set(0,1), vs, am)

}
\seealso{
\code{\link{\%in\%}}
}

