% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_asympto.R
\name{estimate_asympto}
\alias{estimate_asympto}
\title{Estimate the proportion of asymptomatic cases by capture/recapture}
\usage{
estimate_asympto(df, bounds = c("lower", "upper"))
}
\arguments{
\item{df}{A data.frame containing three columns containing \code{date}, the daily
number of \code{new_cases}, and the daily number of \code{new_deaths}.}

\item{bounds}{\code{"lower"}, \code{"upper"}, or both \verb{c("lower, "upper"}) (the
default), telling which bounds of the number of asymptomatic cases are
computed.
associated with the lower and upper bounds.
estimation. \code{FALSE} is never the recommended setting excepted for testing
or debugging purpose.}
}
\value{
A \code{data.frame} with two or three columns (depending on the value of
the \code{bounds} argument):
\itemize{
\item \code{date}: the original \code{date} column from your input dataset \code{df}
\item \code{lower}: the lower bound of asymptomatic cases
\item \code{upper}: the upper bound of asymptomatic cases
}
}
\description{
Estimate the proportion of asymptomatic cases by capture/recapture
}
\examples{

d <- readRDS(system.file("extdata", "covid19_italy.rds", package = "asymptor"))
head(d)

estimate_asympto(d)

}
\references{
Böhning D., Rocchetti I., Maruotti A., Holling H. (2020),
Estimating the undetected infections in the Covid-19 outbreak by harnessing
capture–recapture methods, International Journal of Infectious Diseases,
97, p197-201, \doi{10.1016/j.ijid.2020.06.009}.

Rocchetti I., Böhning D., Holling H., Maruotti A., (2020),
Estimating the size of undetected cases of the SARS-CoV-2 outbreak in
Europe: An upperbound estimator, medRxiv,
\doi{10.1101/2020.07.14.20153445}.
}
