% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{gather}
\alias{gather}
\alias{as.promise.channel}
\alias{collect}
\alias{collector}
\title{Collect iterator / channel items into a vector.}
\usage{
gather(ch, type = list())

\method{as.promise}{channel}(x)

collect(fn, type = list())

collector(fn, type = list())
}
\arguments{
\item{ch}{a \link{channel} object.}

\item{type}{A prototype output vector (similar to the \code{FUN.VALUE}
argument of \link{vapply}) Defaults to \code{list()}.}

\item{x}{a \link{channel}.}

\item{fn}{A function, which should accept a single argument, here
called \code{emit}.}
}
\value{
\code{gather(ch, list())} returns a [\link{promise}] that eventually
resolves with a list. If the channel emits an error, the promise
will reject with that error. The partial results will be attached
to the error's \code{attr(err, "partialResults")}.

\code{collect} returns a vector of the same mode as \code{type}.
}
\description{
\code{gather} takes a \link{channel} as argument and returns a
\link{promise}. All values emitted by the channel will be collected
into a vector matching the prototype mode. After the source
channel closes, the promise will resolve with the collected
vector.

Method \code{as.promise.channel} is a synonym for \code{gather}.

\code{collect} and \code{collector} are used in the
implementation of the above functions.  \code{collect} calls the
function \code{fn} in its argument, supplying a callback of the form
\code{function (val, name=NULL).} I like to call it \code{emit}.  While
\code{fn} is running, it can call \code{emit(x)} any number of times.
After \code{fn} returns, all the values passed to \code{emit} are returned
in a vector, with optional names.

\code{collector()} works similarly to collect() but does
not gather values when your inner function returns. Instead, it
provides your inner function with two callbacks, one to add a
value and the second to extract the value; so you can use that
callback to extract values at a later time. For an example of
\code{collector} usage see the definition of \link{gather}.
}
\examples{

ch <- stream(for (i in 1:10) {await(delay(0.1)); if (i \%\% 3 == 0) yield(i)})
\dontrun{ ch |> gather(numeric(0)) |> then(\(x)cat(x, "\n")) }

#cumulative sum with collect
cumsum <- function(vec) {
  total <- 0
  collect(type=0, function(emit) {
    for (i in vec) total <- emit(total+i)
  })
}

# `as.list.iteror` is implemented simply with `collect`:
as.list.iteror <- function(it) {
  collect(\(yield) repeat yield(nextOr(it, break)))
}
}
\author{
Peter Meilstrup
}
