% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_ES.R
\name{f_ES}
\alias{f_ES}
\title{Expected Shortfall}
\usage{
f_ES(alpha, type_function, params, accuracy = 0.005)
}
\arguments{
\item{alpha}{Numeric argument for Expected-Shortfall, between 0 and 1}

\item{type_function}{String argument : "gaussian" for normal distribution or "skew-t" for t-student distribution}

\item{params}{Numeric vector containing parameters of the distribution}

\item{accuracy}{Scalar value which regulates the accuracy of the ES (default value 1e-05)}
}
\value{
Numeric value for the expected-shortfall given the distribution and the alpha risk.
}
\description{
The function allows to calculate Expected-shortfall for a given distribution. It takes as parameters alpha (risk level), a distribution and the parameters associated with this distribution. For example, for a normal distribution, the user must enter the mean and the standard deviation. Currently, the function can calculate the Expected-shortfall for the normal distribution and for the skew-t distribution (Azzalini and Capitianio, 2003)
}
\examples{
f_ES(0.95, "gaussian", params=c(0,1))
f_ES(0.95, "gaussian", params=c(0,1), accuracy=1e-05)
f_ES(0.9999, "gaussian", params=c(0,1), accuracy=1e-04)

}
\references{
Azzalini, Adelchi, and Antonella Capitanio. "Distributions generated by perturbation of symmetry with emphasis on a multivariate skew t‐distribution." Journal of the Royal Statistical Society: Series B (Statistical Methodology) 65.2 (2003): 367-389.

Azzalini, Adelchi, and Maintainer Adelchi Azzalini. "Package ‘sn’." The skew-normal and skew-t distributions (2015): 1-3.
}
